<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include '../config/function.php';
include '../config/db.php';
include '../config/config.php';

// Initialize variables
$err = "";
$msg = "";
$fullname = $email = $password = "";
if (isset($_POST['submit'])) {
    // Validate Full Name
    if (empty($_POST['fullname'])) {
        $err = 'Enter your full name';
    } else {
        $fullname = text_input($_POST['fullname']);
    }
    // Validate Email
    if (empty($_POST['email'])) {
        $err = 'Email address is required';
    } elseif (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
        $err = 'Invalid email';
    } else {
        $email = text_input($_POST['email']);
        $stmt = mysqli_prepare($link, "SELECT email FROM users WHERE email = ?");
        mysqli_stmt_bind_param($stmt, "s", $email);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_store_result($stmt);
        if (mysqli_stmt_num_rows($stmt) > 0) {
            $err = 'Email already exists';
        }
        mysqli_stmt_close($stmt);
    }
    // Validate Password
    if (empty($_POST['password1'])) {
        $err = 'Password is required';
    } elseif (strlen(text_input($_POST['password1'])) < 6) {
        $err = 'Password should be more than 6 characters';
    } elseif (text_input($_POST['password1']) != text_input($_POST['password2'])) {
        $err = 'Passwords do not match';
    } else {
         $password = text_input($_POST['password1']);
    }
 
    // Insert into database if no errors
if (empty($err)) {
    $first_name = "";  // Empty string for first_name
    $last_name = "";   // Empty string for last_name
    $date_created = date('Y-m-d H:i:s'); // Fixed datetime format
    
    $stmt = mysqli_prepare($link, "INSERT INTO users (fullname, first_name, last_name, email, password, created_at) VALUES (?, ?, ?, ?, ?, ?)");
    mysqli_stmt_bind_param($stmt, "ssssss", $fullname, $first_name, $last_name, $email, $password, $date_created);
    
    if (mysqli_stmt_execute($stmt)) {
        $msg = "REGISTRATION SUCCESSFUL";

            // === WELCOME EMAIL (Elite Auto Dark Design) ===
            $subject = "Welcome to $sitename!";

            $body = "
            <div style='background: #000; padding: 20px; font-family: Arial, sans-serif;'>
                <div style='max-width: 600px; margin: 0 auto; background: #0a0a0a; border-radius: 12px; overflow: hidden; border: 1px solid #1f1f1f;'>
                    
                    <!-- Header with Logo -->
                    <div style='background: #000; padding: 30px 20px; text-align: center;'>
                        <img src='$site_url/images/logo.png' width='120' style='filter: brightness(0) invert(1);'>
                    </div>

                    <!-- Main Content -->
                    <div style='padding: 40px 32px; text-align: center; color: #ffffff;'>
                        <h1 style='font-size: 42px; font-weight: bold; color: #ffffff; margin: 0 0 16px 0; line-height: 1.1;'>
                            Invest. Trade. Drive.
                        </h1>
                        <p style='font-size: 19px; color: #e2e8f0; margin: 20px 0 40px 0; line-height: 1.6;'>
                            Hi <strong>$fullname</strong>,<br>
                            Your Elite Auto account has been successfully created.
                        </p>

                        <p style='font-size: 18px; color: #cbd5e1; margin-bottom: 40px;'>
                            Welcome to the all-in-one platform for crypto investments,<br>
                            live stocks, automated trading, and premium EV inventory.
                        </p>

                        <!-- Login Button -->
                        <a href='$site_url/auth/login.php' style='background: #ffffff; color: #000000; font-weight: bold; font-size: 18px; padding: 16px 40px; border-radius: 8px; text-decoration: none; display: inline-block; margin: 20px 0;'>
                            Start Investing Now
                        </a>

                        <p style='color: #64748b; font-size: 14px; margin-top: 50px;'>
                            We're excited to have you on board.<br>
                            Get ready to invest, trade, and drive the future.
                        </p>
                    </div>

                    <!-- Footer -->
                    <div style='background: #111; padding: 30px; text-align: center; color: #64748b; font-size: 13px; border-top: 1px solid #1f1f1f;'>
                        <p style='margin: 0;'>
                            © 2025 $sitename. All rights reserved.<br>
                            <span style='color: #475569;'>Support Team • $sitename</span>
                        </p>
                    </div>
                </div>
            </div>";

            $send = sendMail($email, $subject, $body);
            // ==============================================

        } else {
            $err = "Database error: " . mysqli_error($link);
        }
        mysqli_stmt_close($stmt);
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="IjqobX7BsTOca4SwVhWh4hCpjUVcVyKDQymEclr2">

    <title>Create Account - Tesla Investment</title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon"
        href="../images/logo.png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <link rel="preload" as="style" href="../app/css/app-1OgqAOn0.css" />
    <link rel="modulepreload" as="script" href="../app/js/app-FoMq_5CK.js" />
    <link rel="stylesheet" href="../app/css/app-1OgqAOn0.css" />
    <script type="module" src="../app/js/app-FoMq_5CK.js"></script>
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
</head>

<?php
if ($err != "") {
    echo customAlert('error', $err);
}
if ($msg != "") {
    echo customAlert('success', $msg);
    echo pageRedirect('3', 'login.php');
}
?>

<body class="font-sans antialiased bg-gray-50 text-black">
    <div class="min-h-screen flex flex-col">
        <!-- Enhanced Navigation -->
        <nav class="bg-white border-b border-gray-100 shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-14">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <a href="../" class="flex items-center group">
                            <img src="../images/logo.png"
                                alt="Tesla Investment"
                                class="h-6 w-auto group-hover:opacity-70 transition-opacity duration-200">
                        </a>
                    </div>

                    <!-- Right Side Links -->
                    <div class="hidden md:flex items-center space-x-6">
                        <a href="../"
                            class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Home</a>
                        <a href="../cars"
                            class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Inventory</a>
                        <a href="login.php"
                            class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Sign
                            In</a>
                        <a href="register.php"
                            class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Register</a>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Enhanced Main Content -->
        <main class="flex-grow flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
            <div class="w-full max-w-sm">
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
                    <!-- Enhanced Header -->
                    <div class="px-6 py-6 text-center">
                        <h1 class="text-xl font-light text-black mb-1">Create Account</h1>
                        <p class="text-xs text-gray-500">Join Tesla Drives today</p>
                    </div>

                    <!-- Registration Form -->
                    <div class="px-6 pb-6">
                        <form method="POST" action="" class="space-y-4">
                            
                            <!-- Name -->
                            <div>
                                <label for="name" class="block text-xs font-medium text-black mb-1">Full Name</label>
                                <input type="text" id="name" name="fullname" value="" required autofocus autocomplete="fullname"
                                    class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                            </div>

                            <!-- Email Address -->
                            <div>
                                <label for="email" class="block text-xs font-medium text-black mb-1">Email</label>
                                <input type="email" id="email" name="email" value="" required autocomplete="username"
                                    class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                            </div>

                            <!-- Password -->
                            <div>
                                <label for="password" class="block text-xs font-medium text-black mb-1">Password</label>
                                <input type="password" id="password" name="password1" required
                                    autocomplete="new-password"
                                    class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                            </div>

                            <!-- Confirm Password -->
                            <div>
                                <label for="password_confirmation"
                                    class="block text-xs font-medium text-black mb-1">Confirm Password</label>
                                <input type="password" id="password_confirmation" name="password2" required
                                    autocomplete="new-password"
                                    class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                            </div>

                            <!-- Submit Button -->
                            <div class="pt-2">
                                <button type="submit" name="submit"
                                    class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                                    Create Account
                                </button>
                            </div>
                        </form>
                    </div>

                   

                    <!-- Login Link -->
                    <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 text-center">
                        <p class="text-xs text-gray-500">
                            Already have an account?
                            <a href="login.php"
                                class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                                Sign in
                            </a>
                        </p>
                    </div>
                </div>

                <!-- Terms Notice -->
                <div class="mt-6 text-center">
                    <p class="text-xs text-gray-400">
                        By creating an account, you agree to our
                        <a href="../terms"
                            class="text-black hover:text-gray-600 transition-colors duration-200">Terms of Service</a>
                        and
                        <a href="../privacy"
                            class="text-black hover:text-gray-600 transition-colors duration-200">Privacy Policy</a>
                    </p>
                </div>
            </div>
        </main>

        <!-- Enhanced Footer -->
        <footer class="bg-black text-white py-6">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="mb-3 md:mb-0">
                        <p class="text-xs text-gray-400">&copy; 2025 Tesla Investment. All rights reserved.</p>
                    </div>
                    <div class="flex space-x-6">
                        <a href="../privacy"
                            class="text-xs text-gray-400 hover:text-white transition-colors duration-200">Privacy
                            Policy</a>
                        <a href="../terms"
                            class="text-xs text-gray-400 hover:text-white transition-colors duration-200">Terms of
                            Service</a>
                        <a href="../contact"
                            class="text-xs text-gray-400 hover:text-white transition-colors duration-200">Contact</a>
                    </div>
                </div>
            </div>
        </footer>
    </div>
</body>

</html>