<?php
session_start();
include '../config/function.php';
include '../config/db.php';
include '../config/config.php';

$msg = "";
$err = "";
$email = $password = "";

if (isset($_POST['submit'])) {
    // Validate inputs
    if (empty($_POST["email"])) {
        $err = "Email is required";
    } else {
        $email = text_input($_POST["email"]);
    }
  
    if (empty($_POST["password"])) {
        $err = "Password is required";
    } else {
        $password = text_input($_POST["password"]);
    }
  
   
  
    if ($err == "" && $email != "" && $password != "") {
        $sql = mysqli_query($link, "SELECT * FROM users WHERE email = '$email'");
        if (mysqli_num_rows($sql) == 0) {
            $err = "Invalid Email";
        } else {
            $data = mysqli_fetch_assoc($sql);
            if ($password != $data['password']) {
                $err = "Incorrect Password";
            } else {
                $_SESSION['USER_LOGIN'] = $data['email'];
                $_SESSION['id'] = $data['id'];
                $msg = "Access granted";

                
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="IjqobX7BsTOca4SwVhWh4hCpjUVcVyKDQymEclr2">

    <title>Sign In - Tesla Investment</title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon"
        href="../images/logo.png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <link rel="preload" as="style" href="../app/css/app-1OgqAOn0.css" />
    <link rel="modulepreload" as="script" href="../app/js/app-FoMq_5CK.js" />
    <link rel="stylesheet" href="../app/css/app-1OgqAOn0.css" />
    <script type="module" src="../app/js/app-FoMq_5CK.js"></script>
    
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
</head>

<?php
if ($err != "") {
    echo customAlert('error', $err);
}
if ($msg != "") {
    echo customAlert('success', $msg);
    echo pageRedirect('3', '../app/dashboard.php');
}
?>

<body class="font-sans antialiased bg-gray-50 text-black">
    <div class="min-h-screen flex flex-col">
        <!-- Enhanced Navigation -->
        <nav class="bg-white border-b border-gray-100 shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-14">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <a href="../" class="flex items-center group">
                            <img src="../images/logo.png"
                                alt="Tesla Investment"
                                class="h-6 w-auto group-hover:opacity-70 transition-opacity duration-200">
                        </a>
                    </div>

                    <!-- Right Side Links -->
                    <div class="hidden md:flex items-center space-x-6">
                        <a href="/"
                            class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Home</a>
                        <a href="../cars"
                            class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Inventory</a>
                        <a href="login.php"
                            class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Sign
                            In</a>
                        <a href="register.php"
                            class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Register</a>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Enhanced Main Content -->
        <main class="flex-grow flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
            <div class="w-full max-w-sm">
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
                    <!-- Enhanced Header -->
                    <div class="px-6 py-6 text-center">
                        <h1 class="text-xl font-light text-black mb-1">Sign In</h1>
                        <p class="text-xs text-gray-500">Access your Tesla Drives account</p>
                    </div>

                    <!-- Session Status -->

                    <!-- Login Form -->
                    <div class="px-6 pb-6">
                        <form method="POST" action="" class="space-y-4">
                            <input type="hidden" name="_token" value="IjqobX7BsTOca4SwVhWh4hCpjUVcVyKDQymEclr2"
                                autocomplete="off">
                            <!-- Email Address -->
                            <div>
                                <label for="email" class="block text-xs font-medium text-black mb-1">Email</label>
                                <input type="email" id="email" name="email" value="" required autofocus
                                    autocomplete="username"
                                    class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                            </div>

                            <!-- Password -->
                            <div>
                                <div class="flex items-center justify-between mb-1">
                                    <label for="password" class="block text-xs font-medium text-black">Password</label>
                                    <a href="forgot-password.php"
                                        class="text-xs text-gray-500 hover:text-black transition-colors duration-200">
                                        Forgot password?
                                    </a>
                                </div>
                                <div class="relative">
                                    <input type="password" id="password" name="password" required
                                        autocomplete="current-password"
                                        class="w-full px-3 py-2.5 pr-10 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                                    <button type="button" onclick="togglePassword()"
                                        class="absolute inset-y-0 right-0 flex items-center pr-3 text-gray-400 hover:text-gray-600 transition-colors">
                                        <svg id="password-show-icon" class="w-4 h-4" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                            </path>
                                        </svg>
                                        <svg id="password-hide-icon" class="w-4 h-4 hidden" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                            </div>

                            <!-- Remember Me -->
                            <div class="flex items-center">
                                <input type="checkbox" id="remember_me" name="remember"
                                    class="w-3.5 h-3.5 text-black border-gray-300 rounded focus:ring-black">
                                <label for="remember_me" class="ml-2 text-xs text-gray-600">
                                    Remember me
                                </label>
                            </div>

                            <!-- Submit Button -->
                            <div class="pt-2">
                                <button type="submit" name="submit"
                                    class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                                    Sign In
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Registration Link -->
                    <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 text-center">
                        <p class="text-xs text-gray-500">
                            Don't have an account?
                            <a href="register.php"
                                class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                                Create account
                            </a>
                        </p>
                    </div>
                </div>

                <!-- Alternative Sign In -->
                <div class="mt-6">
                    <div class="relative">
                        <div class="absolute inset-0 flex items-center">
                            <div class="w-full border-t border-gray-200"></div>
                        </div>
                        <div class="relative flex justify-center text-xs">
                            <span class="px-3 bg-gray-50 text-gray-500">Or continue with</span>
                        </div>
                    </div>

                </div>

                <!-- Security Notice -->
                <div class="mt-6 text-center">
                    <div class="flex items-center justify-center text-gray-400 text-xs">
                        <i data-lucide="shield" class="w-3 h-3 mr-1"></i>
                        Secure login protected by SSL encryption
                    </div>
                </div>

                <script>
                    function togglePassword() {
                        const passwordInput = document.getElementById('password');
                        const showIcon = document.getElementById('password-show-icon');
                        const hideIcon = document.getElementById('password-hide-icon');

                        if (passwordInput.type === 'password') {
                            passwordInput.type = 'text';
                            showIcon.classList.add('hidden');
                            hideIcon.classList.remove('hidden');
                        } else {
                            passwordInput.type = 'password';
                            showIcon.classList.remove('hidden');
                            hideIcon.classList.add('hidden');
                        }
                    }
                </script>
            </div>
        </main>

        <!-- Enhanced Footer -->
        <footer class="bg-black text-white py-6">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="mb-3 md:mb-0">
                        <p class="text-xs text-gray-400">&copy; 2025 Tesla Investment. All rights reserved.</p>
                    </div>
                    <div class="flex space-x-6">
                        <a href="../privacy"
                            class="text-xs text-gray-400 hover:text-white transition-colors duration-200">Privacy
                            Policy</a>
                        <a href="../terms"
                            class="text-xs text-gray-400 hover:text-white transition-colors duration-200">Terms of
                            Service</a>
                        <a href="../contact"
                            class="text-xs text-gray-400 hover:text-white transition-colors duration-200">Contact</a>
                    </div>
                </div>
            </div>
        </footer>
    </div>
</body>

</html>