<?php
include 'header.php';
$msg = $err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = floatval($_POST['amount'] ?? 0);
    $method = $_POST['payment_method_id'] ?? '';
    $wallet = trim($_POST['wallet_address'] ?? '');
    // Validation
    if ($amount < $min_withdrawal) {
      $err = 'Minimum withdrawal is ' . $min_withdrawal . '.';
    } elseif ($amount > $balance) {
        $err = 'Insufficient balance';
    } elseif (!in_array($method, ['BTC','ETH','LTC'])) {
        $err = 'Invalid crypto method';
    } elseif (empty($wallet)) {
        $err = 'Wallet address is required';
    } elseif (strlen($wallet) < 20) {
        $err = 'Invalid wallet address';
    } else {
        $net_amount = $amount - $withdrawal_Fee;
        if ($net_amount < 0) {
            $err = 'Amount too low after fee';
        } else {
            // Start transaction
            mysqli_autocommit($link, false);
            $success = true;
            $sql1 = "UPDATE users SET balance = balance - ? WHERE id = ?";
            $stmt1 = mysqli_prepare($link, $sql1);
            mysqli_stmt_bind_param($stmt1, "si", $amount, $user_id);
            if (!mysqli_stmt_execute($stmt1)) {
                $success = false;
            } else {
                $success = true;
            }
            mysqli_stmt_close($stmt1);
            if ($success) {
                $type = 'withdrawal';
                $status = 'pending';
                $now = date('Y-m-d H:i:s');
                $sql2 = "INSERT INTO transactions
                            (user_id, amount, type, crypto_method, transaction_hash, status, address, created_at)
                         VALUES (?, ?, ?, ?, ?, ?, ?,?)";
                $stmt2 = mysqli_prepare($link, $sql2);
                mysqli_stmt_bind_param($stmt2, "idssssss", $user_id, $amount, $type, $method, $hash, $status, $wallet, $now);
                if (!mysqli_stmt_execute($stmt2)) $success = false;
                mysqli_stmt_close($stmt2);
            }
            if ($success) {
                mysqli_commit($link);
                $msg = "Withdrawal request submitted! You'll receive $$net_amount after processing.";
                $balance -= $amount; // Update UI

                // === WITHDRAWAL CONFIRMATION EMAIL ===
                $subject = "Withdrawal Request Received – $sitename";

                $body = "
                <div style='background: #000; padding: 20px; font-family: Arial, sans-serif;'>
                    <div style='max-width: 600px; margin: 0 auto; background: #0a0a0a; border-radius: 12px; overflow: hidden; border: 1px solid #1f1f1f;'>
                        
                        <!-- Header with Logo -->
                        <div style='background: #000; padding: 30px 20px; text-align: center;'>
                            <img src='$site_url/images/logo-white.png' width='120'>
                        </div>

                        <!-- Main Content -->
                        <div style='padding: 40px 32px; text-align: center; color: #ffffff;'>
                            <h1 style='font-size: 42px; font-weight: bold; color: #ffffff; margin: 0 0 16px 0; line-height: 1.1;'>
                                Withdrawal Requested
                            </h1>
                            <p style='font-size: 19px; color: #e2e8f0; margin: 20px 0 40px 0; line-height: 1.6;'>
                                Hi <strong>$fullname</strong>,<br>
                                Your withdrawal request has been successfully submitted.
                            </p>

                            <p style='font-size: 18px; color: #cbd5e1; margin-bottom: 40px;'>
                                Amount Requested: <strong>$$amount $method</strong><br>
                                You will receive: <strong>$$net_amount $method</strong><br>
                                Wallet Address: <strong>$wallet</strong><br>
                                Status: <strong>Pending Approval</strong>
                            </p>

                            <!-- View Portfolio Button -->
                            <a href='$site_url/portfolio.php' style='background: #ffffff; color: #000000; font-weight: bold; font-size: 18px; padding: 16px 40px; border-radius: 8px; text-decoration: none; display: inline-block; margin: 20px 0;'>
                                View My Portfolio
                            </a>

                            <p style='color: #64748b; font-size: 14px; margin-top: 50px;'>
                                Your withdrawal is under review. You’ll receive your funds within 24 hours once approved.<br>
                                Thank you for trusting $sitename!
                            </p>
                        </div>

                        <!-- Footer -->
                        <div style='background: #111; padding: 30px; text-align: center; color: #64748b; font-size: 13px; border-top: 1px solid #1f1f1f;'>
                            <p style='margin: 0;'>
                                © 2025 $sitename. All rights reserved.<br>
                                <span style='color: #475569;'>Support Team • $sitename</span>
                            </p>
                        </div>
                    </div>
                </div>";

                $send = sendMail($email, $subject, $body);
                // ==============================================

            } else {
                mysqli_rollback($link);
                $msg = 'Transaction failed. Please try again.';
            }
            mysqli_autocommit($link, true);
        }
    }
}
?>

<!-- =================================== HTML UI =================================== -->
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <!-- Top Bar -->
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()" class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">Withdraw Funds</div>
            </div>
            
        </div>
    </header>

    <!-- Flash Message -->
    <?php if ($msg): ?>
        <div class="mx-6 mt-4 p-4 rounded-lg text-sm <?php echo strpos($msg, 'submitted') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
            <?php echo htmlspecialchars($msg); ?>
        </div>
    <?php endif; ?>

    <!-- Main Content -->
    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-2xl mx-auto">

            <!-- Header Card -->
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16"></div>
                    <div class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8"></div>
                </div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                        <div class="mb-4 lg:mb-0 lg:flex-1">
                            <h1 class="text-xl font-light mb-1">Withdraw Funds</h1>
                            <p class="text-gray-300 text-sm">Transfer money from your wallet to your chosen destination</p>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-xs text-gray-300 mb-1">Available Balance</p>
                                    <p class="text-lg font-light">$<?php echo number_format($balance, 2); ?></p>
                                </div>
                                <div class="w-10 h-10 flex items-center justify-center">
                                    <i data-lucide="wallet" class="w-5 h-5 text-white"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Withdrawal Form -->
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <form method="POST" class="space-y-6">
                    <input type="hidden" name="_token" value="jggz3Sr4oLC5FU3bRDH6Rimfxx1uZSlQyyrscXTa">

                    <!-- Amount -->
                    <div>
                        <label for="amount" class="block text-sm font-medium text-gray-700 mb-2">Withdrawal Amount</label>
                        <div class="relative">
                            <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500">$</span>
                            <input type="number" id="amount" name="amount" step="0.01" min="<?php echo $min_withdrawal ?>" max="<?php echo $balance; ?>"
                                   class="w-full pl-8 pr-4 py-3 border <?php echo $err ? 'border-red-500' : 'border-gray-300'; ?> rounded-lg focus:ring-2 focus:ring-black focus:border-transparent"
                                   placeholder="0.00" required>
                        </div>
                        <p class="text-xs text-gray-500 mt-1">Min: $<?php echo number_format($min_withdrawal, 2) ?> | Max: $<?php echo number_format($balance, 2); ?></p>
                        <?php if ($err && strpos($err, 'insufficient') !== false): ?>
                            <p class="text-xs text-red-600 mt-1"><?php echo $err; ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Crypto Method -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-3">Withdrawal Method</label>
                        <div class="space-y-3">
                            <?php foreach (['BTC','ETH','LTC'] as $m): ?>
                            <label class="flex items-center p-4 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50 transition-all group">
                                <input type="radio" name="payment_method_id" value="<?php echo $m; ?>"
                                       class="w-4 h-4 text-black focus:ring-black" required>
                                <div class="ml-3 flex items-center flex-1">
                                    <img src="image/<?php echo $m === 'BTC' ? 'ORlsQwv0PZBkspRvbK9uU5RRxhcyGuj2yC1MtOrQ.png' : ($m === 'ETH' ? 'D8Kmhhgnkh2f4M8kCLnMRnacE2G3Tq0oX97LkhsG.png' : 'yfA6ZHo9c2RBYPipI94Mw2jRNfR6qOyhtreYRlo2.png'); ?>"
                                         alt="<?php echo $m; ?>" class="w-8 h-8 mr-3">
                                    <div>
                                        <p class="font-medium text-black text-sm"><?php echo $m === 'BTC' ? 'Bitcoin' : ($m === 'ETH' ? 'Ethereum' : 'Litecoin'); ?></p>
                                    </div>
                                    <i data-lucide="arrow-right" class="w-4 h-4 text-gray-400 ml-auto group-hover:text-gray-600"></i>
                                </div>
                            </label>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <!-- Wallet Address -->
                    <div id="destination-crypto">
                        <label for="wallet_address" class="block text-sm font-medium text-gray-700 mb-2">Destination Wallet Address</label>
                        <input type="text" id="wallet_address" name="wallet_address"
                               class="w-full px-4 py-3 border <?php echo $err && !strpos($err, 'insufficient') ? 'border-red-500' : 'border-gray-300'; ?> rounded-lg focus:ring-2 focus:ring-black"
                               placeholder="e.g. bc1q..." required>
                        <?php if ($err && !strpos($err, 'insufficient')): ?>
                            <p class="text-xs text-red-600 mt-1"><?php echo $err; ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Fee Breakdown -->
                    <div class="bg-gradient-to-br from-red-50 to-red-100 rounded-lg p-4 border border-red-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-red-800">Fee Breakdown</span>
                            <i data-lucide="calculator" class="w-4 h-4 text-red-600"></i>
                        </div>
                        <div class="space-y-2">
                            <div class="flex justify-between text-xs">
                                <span class="text-red-700">Amount:</span>
                                <span id="withdrawal-amount" class="font-medium text-red-800">$0.00</span>
                            </div>
                            <div class="flex justify-between text-xs">
                                <span class="text-red-700">Fee:</span>
                                <span id="processing-fee" class="font-medium text-red-800">$<?php echo number_format($withdrawal_Fee, 2); ?></span>
                            </div>
                            <div class="border-t border-red-300 pt-2">
                                <div class="flex justify-between text-xs">
                                    <span class="font-semibold text-red-800">You'll Receive:</span>
                                    <span id="net-amount" class="font-bold text-red-900">$0.00</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Submit -->
                    <button type="submit" class="w-full bg-black text-white py-3.5 rounded-lg font-medium hover:bg-gray-800 flex items-center justify-center space-x-2">
                        <i data-lucide="minus" class="w-5 h-5"></i>
                        <span>Withdraw Funds</span>
                    </button>
                </form>
            </div>
        </div>

        <!-- Scripts -->
        <script>
            const amountInput = document.getElementById('amount');
            const withdrawalAmount = document.getElementById('withdrawal-amount');
            const netAmount = document.getElementById('net-amount');
            const fee = <?php echo $withdrawal_Fee; ?>;

            function updateFee() {
                const amt = parseFloat(amountInput.value) || 0;
                const net = amt - fee;
                withdrawalAmount.textContent = `$${amt.toFixed(2)}`;
                netAmount.textContent = `$${net >= 0 ? net.toFixed(2) : '0.00'}`;
            }
            amountInput.addEventListener('input', updateFee);
            updateFee();

            // Show wallet field only for crypto
            document.querySelectorAll('input[name="payment_method_id"]').forEach(r => {
                r.addEventListener('change', () => {
                    document.getElementById('destination-crypto').classList.remove('hidden');
                });
            });
        </script>
    </main>
</div>

<?php include 'footer.php'; ?>