<?php
include 'header.php';

// ---------------------------------------------------------------
// 2. STATISTICS – THIS MONTH (confirmed only)
// ---------------------------------------------------------------
$month = date('Y-m'); // e.g. 2026-01

$total_deposits = 0.00;
$total_withdrawals = 0.00;
$total_investments = 0.00;

// Deposits
$stmt = mysqli_prepare($link,
    "SELECT COALESCE(SUM(amount), 0)
     FROM transactions
     WHERE user_id = ? 
       AND type = 'deposit'
       AND DATE_FORMAT(created_at, '%Y-%m') = ?");
mysqli_stmt_bind_param($stmt, "is", $user_id, $month);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $sum);
mysqli_stmt_fetch($stmt);
$total_deposits = (float)$sum;
mysqli_stmt_close($stmt);

// Withdrawals
$stmt = mysqli_prepare($link,
    "SELECT COALESCE(SUM(amount), 0)
     FROM transactions
     WHERE user_id = ? 
       AND type = 'withdrawal'
       AND DATE_FORMAT(created_at, '%Y-%m') = ?");
mysqli_stmt_bind_param($stmt, "is", $user_id, $month);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $sum);
mysqli_stmt_fetch($stmt);
$total_withdrawals = (float)$sum;
mysqli_stmt_close($stmt);

// Investments (buys only)
$stmt = mysqli_prepare($link,
    "SELECT COALESCE(SUM(amount), 0)
     FROM investments
     WHERE user_id = ?
       AND type IN ('buy', 'investment')
       AND DATE_FORMAT(created_at, '%Y-%m') = ?");
mysqli_stmt_bind_param($stmt, "is", $user_id, $month);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $total_investments);
mysqli_stmt_fetch($stmt);
$total_investments = (float)$total_investments;
mysqli_stmt_close($stmt);

// ---------------------------------------------------------------
// 3. RECENT 4 TRANSACTIONS (combined, latest first)
// ---------------------------------------------------------------
$recent = [];

// Funding transactions
$stmt = mysqli_prepare($link, "
    SELECT type, amount, crypto_method, status, created_at, 'funding' AS source
    FROM transactions
    WHERE user_id = ? AND type IN ('deposit', 'withdrawal')
    ORDER BY created_at DESC
    LIMIT 10
");
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
$res_funding = mysqli_stmt_get_result($stmt);
while ($row = mysqli_fetch_assoc($res_funding)) {
    $recent[] = $row;
}
mysqli_stmt_close($stmt);

// Investment transactions
$stmt = mysqli_prepare($link, "
    SELECT type AS orig_type, amount, plan_name AS crypto_method, status, created_at, 'investment' AS source
    FROM investments
    WHERE user_id = ? AND type IN ('buy', 'sell')
    ORDER BY created_at DESC
    LIMIT 10
");
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
$res_invest = mysqli_stmt_get_result($stmt);
while ($row = mysqli_fetch_assoc($res_invest)) {
    $row['type'] = $row['orig_type'] === 'buy' ? 'investment_buy' : 'investment_sell';
    unset($row['orig_type']);
    $recent[] = $row;
}
mysqli_stmt_close($stmt);

// Sort by date DESC and keep only top 4
usort($recent, function($a, $b) {
    return strtotime($b['created_at']) - strtotime($a['created_at']);
});
$recent = array_slice($recent, 0, 4); // Only 4 most recent

mysqli_close($link);
?>
<!-- =================================== HTML =================================== -->
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <!-- Top Bar -->
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()" class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">Wallet</div>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-7xl mx-auto">
            <!-- Wallet Header -->
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                    <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
                </div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                        <div class="mb-4 lg:mb-0 lg:flex-1">
                            <h1 class="text-xl font-light mb-1">Wallet Balance</h1>
                            <p class="text-gray-300 text-sm">Your available funds for investing</p>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-xs text-gray-300 mb-1">Available Balance</p>
                                    <p class="text-xl font-light">$<?= number_format($balance, 2); ?></p>
                                </div>
                                <div class="w-10 h-10 flex items-center justify-center">
                                    <i data-lucide="wallet" class="w-5 h-5 text-white"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="grid grid-cols-2 md:grid-cols-2 gap-3 mb-6">
                <a href="deposit.php" class="group bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                    <div class="absolute inset-0 bg-gradient-to-br from-green-50 to-green-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                    <div class="relative z-10">
                        <div class="w-10 h-10 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="plus" class="w-5 h-5 text-green-500"></i>
                        </div>
                        <h3 class="font-medium text-black text-sm mb-1">Deposit Funds</h3>
                        <p class="text-xs text-gray-500 mb-2">Add money to your wallet</p>
                        <div class="flex items-center text-green-600 text-xs font-medium">
                            <span>Add Funds</span>
                            <i data-lucide="arrow-right" class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                        </div>
                    </div>
                </a>
                <a href="withdraw.php" class="group bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                    <div class="absolute inset-0 bg-gradient-to-br from-red-50 to-red-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                    <div class="relative z-10">
                        <div class="w-10 h-10 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="minus" class="w-5 h-5 text-red-500"></i>
                        </div>
                        <h3 class="font-medium text-black text-sm mb-1">Withdraw Funds</h3>
                        <p class="text-xs text-gray-500 mb-2">Transfer money out</p>
                        <div class="flex items-center text-red-600 text-xs font-medium">
                            <span>Withdraw</span>
                            <i data-lucide="arrow-right" class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                        </div>
                    </div>
                </a>
            </div>

            <!-- This Month Statistics -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-xs font-medium text-gray-500 mb-1">Deposits This Month</p>
                            <p class="text-lg font-light text-black mb-1">$<?= number_format($total_deposits, 2); ?></p>
                            <a href="transactions_history.php" class="text-xs text-green-600 hover:underline">View History →</a>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="trending-up" class="w-5 h-5 text-green-500"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-xs font-medium text-gray-500 mb-1">Withdrawals This Month</p>
                            <p class="text-lg font-light text-black mb-1">$<?= number_format($total_withdrawals, 2); ?></p>
                            <a href="transactions_history.php" class="text-xs text-red-600 hover:underline">View History →</a>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="trending-down" class="w-5 h-5 text-red-500"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-xs font-medium text-gray-500 mb-1">Invested This Month</p>
                            <p class="text-lg font-light text-black mb-1">$<?= number_format($total_investments, 2); ?></p>
                            <a href="transactions.php" class="text-xs text-blue-600 hover:underline">View Investments →</a>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="pie-chart" class="w-5 h-5 text-blue-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity (Only 4 latest) -->
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-lg font-light text-black mb-1">Recent Activity</h3>
                        <p class="text-xs text-gray-500">Latest 4 transactions</p>
                    </div>
                    <!--<a href="#" class="text-xs text-black hover:text-gray-600 transition-colors duration-200 font-medium">-->
                    <!--    View All <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>-->
                    <!--</a>-->
                </div>
                <div class="space-y-3">
                    <?php if (empty($recent)): ?>
                        <p class="text-center text-gray-500 py-6">No recent activity.</p>
                    <?php else: ?>
                        <?php foreach ($recent as $tx): ?>
                            <?php
                            switch ($tx['type']) {
                                case 'deposit':
                                    $icon = 'plus'; $color = 'text-green-500'; $amount_clr = 'text-green-600'; $sign = '+'; $label = 'Deposit';
                                    break;
                                case 'withdrawal':
                                    $icon = 'minus'; $color = 'text-red-500'; $amount_clr = 'text-red-600'; $sign = '-'; $label = 'Withdrawal';
                                    break;
                                case 'investment_buy':
                                    $icon = 'pie-chart'; $color = 'text-blue-500'; $amount_clr = 'text-blue-600'; $sign = '-'; $label = 'Investment Buy';
                                    break;
                                case 'investment_sell':
                                    $icon = 'dollar-sign'; $color = 'text-purple-500'; $amount_clr = 'text-purple-600'; $sign = '+'; $label = 'Investment Sell';
                                    break;
                                default:
                                    $icon = 'activity'; $color = 'text-gray-500'; $amount_clr = 'text-gray-600'; $sign = ''; $label = ucfirst($tx['type']);
                            }

                           $status = strtolower($tx['status'] ?? 'pending');

                            if ($status === 'confirmed') {
                                $status_class = 'bg-green-100 text-green-800';
                            } elseif ($status === 'pending') {
                                $status_class = 'bg-yellow-100 text-yellow-800';
                            } else {
                                $status_class = 'bg-gray-100 text-gray-800';
                            }

                            $date = date('M j, Y', strtotime($tx['created_at']));
                            $method = !empty($tx['crypto_method']) ? strtoupper($tx['crypto_method']) : '—';
                            ?>
                            <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors duration-200 group">
                                <div class="w-10 h-10 flex items-center justify-center">
                                    <i data-lucide="<?= $icon ?>" class="w-5 h-5 <?= $color ?>"></i>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <h4 class="font-medium text-black text-sm truncate"><?= $label ?></h4>
                                    <p class="text-xs text-gray-600"><?= $method ?></p>
                                    <p class="text-xs text-gray-500"><?= $date ?></p>
                                </div>
                                <div class="text-right">
                                    <p class="font-medium text-black text-sm <?= $amount_clr ?>">
                                        <?= $sign ?>$<?= number_format($tx['amount'], 2) ?>
                                    </p>
                                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium <?= $status_class ?>">
                                        <?= ucfirst($tx['status'] ?? 'pending') ?>
                                    </span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>
</div>

<?php include 'footer.php'; ?>