<?php
include 'header.php';

// ---------------------------------------------------------------------
// 1. Get stock (via id or symbol)
// ---------------------------------------------------------------------
$stock_id = (int)($_GET['stock_id'] ?? 0);
$symbol   = strtoupper(trim($_GET['symbol'] ?? ''));

if ($stock_id <= 0 && $symbol === '') {
    die('Invalid request.');
}

// Fetch stock
if ($stock_id > 0) {
    $stmt = mysqli_prepare($link, "SELECT symbol, name, price, previous_close, volume, market_cap FROM stocks WHERE id = ?");
    mysqli_stmt_bind_param($stmt, "i", $stock_id);
} else {
    $stmt = mysqli_prepare($link, "SELECT id, name, price, previous_close, volume, market_cap FROM stocks WHERE symbol = ?");
    mysqli_stmt_bind_param($stmt, "s", $symbol);
}
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $db_symbol, $name, $price, $prev_close, $volume, $market_cap);
if (!mysqli_stmt_fetch($stmt)) {
    die('Stock not found.');
}
mysqli_stmt_close($stmt);

if ($stock_id <= 0) $stock_id = $db_symbol;
$symbol = $db_symbol;

// ---------------------------------------------------------------------
// 2. Process BUY
// ---------------------------------------------------------------------
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quantity = (int)($_POST['quantity'] ?? 0);
    if ($quantity < 1) {
        $message = '<p class="text-red-600 text-sm">Enter at least 1 share.</p>';
    } else {
        $subtotal = $quantity * $price;
        $fee      = $subtotal * 0.0025; // 0.25%
        $total    = $subtotal + $fee;

        // Get user balance
        $stmt = mysqli_prepare($link, "SELECT balance FROM users WHERE id = ?");
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_bind_result($stmt, $balance);
        mysqli_stmt_fetch($stmt);
        mysqli_stmt_close($stmt);

        if ($total > $balance) {
            $message = '<p class="text-red-600 text-sm">Insufficient balance. Need $' . number_format($total, 2) . '</p>';
        } else {
            // Insert transaction
            $ins = mysqli_prepare(
                $link,
                "INSERT INTO stock_transactions
                 (user_id, stock_id, symbol, company_name, type, shares, price_per_share, total_amount, fee)
                 VALUES (?, ?, ?, ?, 'buy', ?, ?, ?, ?)"
            );
            mysqli_stmt_bind_param(
                $ins, "iisssddd",
                $user_id, $stock_id, $symbol, $name, $quantity, $price, $subtotal, $fee
            );
            $ok = mysqli_stmt_execute($ins);
            mysqli_stmt_close($ins);

            if ($ok) {
                // Deduct balance
                mysqli_query($link, "UPDATE users SET balance = balance - $total WHERE id = $user_id");
                $message = '<p class="text-green-600 text-sm">Buy order executed!</p>';
                echo '<script>setTimeout(() => { window.location = "stocks.php?id=' . $stock_id . '"; }, 1500);</script>';
            } else {
                $message = '<p class="text-red-600 text-sm">Database error. Try again.</p>';
            }
        }
    }
}

// ---------------------------------------------------------------------
// 3. Formatting
// ---------------------------------------------------------------------
$change_pct = $prev_close > 0 ? (($price - $prev_close) / $prev_close) * 100 : 0;
$change_sign = $change_pct >= 0 ? '' : '';
$change_cls  = $change_pct >= 0 ? 'text-red-400' : 'text-red-400'; // matches your design
$logo_url = "https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/{$symbol}.png";
?>

<!-- ================================================================ -->
<!-- ======================= MAIN LAYOUT ============================ -->
<!-- ================================================================ -->
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <!-- Top Bar -->
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()" class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">
                    Buy <?= htmlspecialchars($symbol) ?>
                </div>
            </div>
            <!--<div class="flex items-center space-x-3">-->
            <!--    <div class="relative">-->
            <!--        <button onclick="toggleNotifications()" class="relative p-2 text-gray-500 hover:text-gray-700 rounded-md hover:bg-gray-100">-->
            <!--            <i data-lucide="bell" class="w-5 h-5"></i>-->
            <!--            <span id="notification-badge" class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center hidden">0</span>-->
            <!--        </button>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
    </header>

    <!-- Page Content -->
    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-4xl mx-auto">
            <!-- Header -->
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16"></div>
                    <div class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8"></div>
                </div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                        <div class="mb-4 lg:mb-0 lg:flex-1">
                            <h1 class="text-xl font-light mb-1">Buy <?= htmlspecialchars($symbol) ?></h1>
                            <p class="text-gray-300 text-sm"><?= htmlspecialchars($name) ?> • Technology</p>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-xs text-gray-300 mb-1">Current Price</p>
                                    <p class="text-lg font-light">$<?= number_format($price, 2) ?></p>
                                    <p class="text-xs <?= $change_cls ?>">
                                        <?= $change_sign ?><?= number_format($change_pct, 2) ?>%
                                    </p>
                                </div>
                                <div class="w-10 h-10 flex items-center justify-center">
                                    <img src="<?= $logo_url ?>" alt="<?= $symbol ?>" class="w-8 h-8 rounded">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Chart -->
            <!--<div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100 mb-6">-->
            <!--    <div class="flex items-center justify-between mb-4">-->
            <!--        <h3 class="text-lg font-medium text-gray-900"><?= $symbol ?> Price Chart</h3>-->
            <!--        <div class="flex space-x-2">-->
            <!--            <button type="button" class="chart-period-btn px-3 py-1 text-xs rounded-lg border border-gray-300 bg-black text-white" data-period="1m">1M</button>-->
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="relative">-->
            <!--        <canvas id="stockChart" class="w-full h-64"></canvas>-->
            <!--    </div>-->
            <!--</div>-->

            <!-- Buy Form -->
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <form method="POST" class="space-y-6">
                    <input type="hidden" name="_token" value="<?= $_SESSION['csrf_token'] ?? 'HkPgnpzcNQsvRAYTgBb4ntsiyoHWMRV3LF98KVWu' ?>">

                    <?php if ($message): ?>
                        <div class="p-3 rounded-lg bg-gray-50 text-sm"><?= $message ?></div>
                    <?php endif; ?>

                    <!-- Quantity -->
                    <div>
                        <label for="quantity" class="block text-sm font-medium text-gray-700 mb-2">Number of Shares</label>
                        <div class="relative">
                            <input type="number" id="quantity" name="quantity" step="1" min="1" max="10000" value="" required
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent"
                                   placeholder="0">
                        </div>
                        <p class="text-xs text-gray-500 mt-1">Maximum shares: 10,000</p>
                    </div>

                    <!-- Stock Info -->
                    <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-lg p-4 border border-blue-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-blue-800">Stock Information</span>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <img src="<?= $logo_url ?>" alt="<?= $symbol ?>" class="w-6 h-6 rounded">
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-4">
                            <div><p class="text-xs text-blue-700 mb-1">Current Price</p><p class="text-sm font-medium text-blue-800">$<?= number_format($price, 2) ?></p></div>
                            <div><p class="text-xs text-blue-700 mb-1">Today's Change</p><p class="text-sm font-medium <?= $change_cls ?>"><?= $change_sign ?><?= number_format($change_pct, 2) ?>%</p></div>
                            <div><p class="text-xs text-blue-700 mb-1">Volume</p><p class="text-sm font-medium text-blue-800"><?= number_format($volume) ?></p></div>
                            <div><p class="text-xs text-blue-700 mb-1">Market Cap</p><p class="text-sm font-medium text-blue-800">$<?= number_format($market_cap / 1_000_000, 1) ?>M</p></div>
                        </div>
                    </div>

                    <!-- Analyst (static - optional to make dynamic) -->
                    <div class="bg-gradient-to-br from-purple-50 to-purple-100 rounded-lg p-4 border border-purple-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-purple-800">Analyst Recommendations</span>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="users" class="w-4 h-4 text-purple-600"></i>
                            </div>
                        </div>
                        <div class="space-y-2">
                            <div class="flex items-center justify-between">
                                <span class="text-xs text-purple-700">Consensus</span>
                                <span class="text-sm font-medium text-blue-600">Buy</span>
                            </div>
                            <div class="flex items-center justify-between">
                                <span class="text-xs text-purple-700">Buy Rating</span>
                                <span class="text-sm font-medium text-purple-800">66.07%</span>
                            </div>
                            <div class="w-full bg-purple-200 rounded-full h-2">
                                <div class="bg-purple-600 h-2 rounded-full" style="width: 66.07%"></div>
                            </div>
                            <div class="grid grid-cols-5 gap-2 text-xs text-purple-700">
                                <div class="text-center"><div class="font-medium">Strong Buy</div><div>15</div></div>
                                <div class="text-center"><div class="font-medium">Buy</div><div>22</div></div>
                                <div class="text-center"><div class="font-medium">Hold</div><div>17</div></div>
                                <div class="text-center"><div class="font-medium">Sell</div><div>2</div></div>
                                <div class="text-center"><div class="font-medium">Strong Sell</div><div>0</div></div>
                            </div>
                        </div>
                    </div>

                    <!-- Breakdown -->
                    <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-lg p-4 border border-green-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-green-800">Purchase Breakdown</span>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="calculator" class="w-4 h-4 text-green-600"></i>
                            </div>
                        </div>
                        <div class="space-y-2">
                            <div class="flex justify-between"><span class="text-sm text-green-700">Price per Share</span><span class="text-sm font-medium text-green-800">$<?= number_format($price, 2) ?></span></div>
                            <div class="flex justify-between"><span class="text-sm text-green-700">Number of Shares</span><span class="text-sm font-medium text-green-800" id="shares-display">0</span></div>
                            <div class="flex justify-between"><span class="text-sm text-green-700">Subtotal</span><span class="text-sm font-medium text-green-800" id="subtotal-display">$0.00</span></div>
                            <div class="flex justify-between"><span class="text-sm text-green-700">Trading Fee (0.25%)</span><span class="text-sm font-medium text-green-800" id="fee-display">$0.00</span></div>
                            <hr class="border-green-300">
                            <div class="flex justify-between"><span class="text-sm font-medium text-green-800">Total Cost</span><span class="text-sm font-bold text-green-800" id="total-display">$0.00</span></div>
                        </div>
                    </div>

                    <!-- Wallet -->
                    <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg p-4 border border-gray-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-gray-800">Wallet Balance</span>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="wallet" class="w-4 h-4 text-gray-600"></i>
                            </div>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-700">Available Funds</span>
                            <span class="text-sm font-medium text-gray-800" id="balance-display">$<?= number_format($balance ?? 0, 2) ?></span>
                        </div>
                        <div class="flex justify-between items-center mt-1">
                            <span class="text-sm text-gray-700">After Purchase</span>
                            <span class="text-sm font-medium text-gray-800" id="remaining-display">$<?= number_format($balance ?? 0, 2) ?></span>
                        </div>
                    </div>

                    <!-- Submit -->
                    <button type="submit"
                            class="w-full bg-black text-white py-3 px-6 rounded-lg font-medium hover:bg-gray-800 transition-colors duration-200 flex items-center justify-center">
                        <i data-lucide="shopping-cart" class="w-4 h-4 mr-2"></i>
                        Buy Shares
                    </button>
                </form>
            </div>
        </div>

        <!-- Chart.js + Logic -->
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const price = <?= $price ?>;
                const walletBalance = <?= $balance ?? 0 ?>;
                const quantityInput = document.getElementById('quantity');
                const sharesDisplay = document.getElementById('shares-display');
                const subtotalDisplay = document.getElementById('subtotal-display');
                const feeDisplay = document.getElementById('fee-display');
                const totalDisplay = document.getElementById('total-display');
                const remainingDisplay = document.getElementById('remaining-display');
                const balanceDisplay = document.getElementById('balance-display');
                const submitBtn = document.querySelector('button[type="submit"]');

                balanceDisplay.textContent = '$' + walletBalance.toFixed(2);
                remainingDisplay.textContent = '$' + walletBalance.toFixed(2);

                function updateCalculations() {
                    const qty = parseInt(quantityInput.value) || 0;
                    const subtotal = qty * price;
                    const fee = subtotal * 0.0025;
                    const total = subtotal + fee;
                    const remaining = walletBalance - total;

                    sharesDisplay.textContent = qty.toLocaleString();
                    subtotalDisplay.textContent = '$' + subtotal.toFixed(2);
                    feeDisplay.textContent = '$' + fee.toFixed(2);
                    totalDisplay.textContent = '$' + total.toFixed(2);
                    remainingDisplay.textContent = '$' + (remaining >= 0 ? remaining.toFixed(2) : '0.00');

                    if (qty < 1 || total > walletBalance) {
                        submitBtn.disabled = true;
                        submitBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    } else {
                        submitBtn.disabled = false;
                        submitBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    }
                }

                quantityInput.addEventListener('input', updateCalculations);
                updateCalculations();

                // Chart (reuse your existing logic)
                const ctx = document.getElementById('stockChart').getContext('2d');
                let stockChart = new Chart(ctx, {
                    type: 'line',
                    data: { labels: [], datasets: [{ label: 'Price', data: [], borderColor: '#10B981', backgroundColor: '#10B981', fill: true, tension: 0.4 }] },
                    options: { /* same as yours */ }
                });

                document.querySelector('.chart-period-btn')?.addEventListener('click', () => {
                    fetch(`/api/stocks/<?= $symbol ?>/chart-data?period=1m`)
                        .then(r => r.json())
                        .then(d => { if (d.success) { stockChart.data = d.chartData; stockChart.update(); } });
                });
            });
        </script>
    </main>
</div>

<?php include 'footer.php'; ?>