<?php
include 'header.php';


$err_name = $err_image = $err_cur = $err_new = $err_conf = $msg = '';
$new_img_path = $profile_picture;


if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // ----- NAME -----
    $name = text_input($_POST['name'] ?? '');
    if (empty($name)) {
        $err_name = 'Full name is required';
    } elseif (strlen($name) < 2) {
        $err_name = 'Name must be at least 2 characters';
    }

    // ----- IMAGE UPLOAD -----
    $upload_dir = '../uploads/profile/';
    if (!empty($_FILES['profile_image']['name'])) {
        $file = $_FILES['profile_image'];
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];

        if ($file['error'] !== 0) {
            $err_image = 'Upload error';
        } elseif ($file['size'] > 2 * 1024 * 1024) {
            $err_image = 'Max 2 MB';
        } elseif (!in_array($ext, $allowed)) {
            $err_image = 'Only JPG, PNG, GIF allowed';
        } else {
            $new_name = "user_{$user_id}_" . time() . ".$ext";
            $dest = $upload_dir . $new_name;

            if (move_uploaded_file($file['tmp_name'], $dest)) {
                $new_img_path = $new_name;

            } else {
                $err_image = 'Failed to save image';
            }
        }
    }


    // ----- PASSWORD -----
    $cur_pass = text_input($_POST['current_password'] ?? '');
    $new_pass = text_input($_POST['password'] ?? '');
    $conf_pass = text_input($_POST['password_confirmation'] ?? '');

    $update_pass = false;

    if (!empty($cur_pass) || !empty($new_pass) || !empty($conf_pass)) {
        if (empty($cur_pass)) {
            $err_cur = 'Current password required';
        } elseif ($cur_pass !== $user_password) { 
            $err_cur = 'Current password is incorrect';
        }

        if (empty($new_pass)) {
            $err_new = 'New password required';
        } elseif (strlen($new_pass) < 6) {
            $err_new = 'Password must be >= 6 characters';
        }

        if ($new_pass !== $conf_pass) {
            $err_conf = 'Passwords do not match';
        }

        if (empty($err_cur) && empty($err_new) && empty($err_conf)) {
            $update_pass = true;
        }
    }

   
   
    if (empty($err_name) && empty($err_image) && empty($err_cur) && empty($err_new) && empty($err_conf)) {

        if ($update_pass) {
            $sql = "UPDATE users SET fullname = ?, profile_picture = ?, password = ? WHERE id = ?";
            $stmt = mysqli_prepare($link, $sql);
            mysqli_stmt_bind_param($stmt, "sssi", $name, $new_img_path, $new_pass, $user_id);
        } else {
            $sql = "UPDATE users SET fullname = ?, profile_picture = ? WHERE id = ?";
            $stmt = mysqli_prepare($link, $sql);
            mysqli_stmt_bind_param($stmt, "ssi", $name, $new_img_path, $user_id);
        }

        if (mysqli_stmt_execute($stmt)) {
            $msg = 'Profile updated successfully!';
        } else {
            $msg = 'Database error: ' . mysqli_error($link);
        }
        mysqli_stmt_close($stmt);
    }
}
?>


<!-- =================================== HTML UI =================================== -->
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <!-- Top Bar -->
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()"
                    class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">Profile Settings</div>
            </div>
            <div class="flex items-center space-x-3">
                <div class="relative">
                    <button onclick="toggleNotifications()"
                        class="relative p-2 text-gray-500 hover:text-gray-700 rounded-md hover:bg-gray-100">
                        <i data-lucide="bell" class="w-5 h-5"></i>
                        <span id="notification-badge"
                            class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center hidden">0</span>
                    </button>
                    <div id="notifications-dropdown"
                        class="hidden absolute right-0 mt-2 w-80 bg-white rounded-lg shadow-lg border border-gray-200 z-50">
                        <div class="p-3 border-b border-gray-200">
                            <div class="flex items-center justify-between">
                                <h3 class="text-sm font-medium text-black">Notifications</h3>
                                <button onclick="markAllNotificationsAsRead()"
                                    class="text-xs text-gray-500 hover:text-gray-700">Mark all read</button>
                            </div>
                        </div>
                        <div id="notifications-list" class="max-h-64 overflow-y-auto">
                            <div class="p-3 text-center">
                                <div class="w-6 h-6 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-2">
                                    <i data-lucide="loader-2" class="w-3 h-3 text-gray-400 animate-spin"></i>
                                </div>
                                <p class="text-xs text-gray-500">Loading notifications...</p>
                            </div>
                        </div>
                        <div class="p-3 border-t border-gray-200">
                            <a href="https://tesla.cycloverseworld.info/notifications"
                                class="text-xs text-black hover:text-gray-600 font-medium">View all notifications</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Flash Message -->
    <?php if ($msg): ?>
        <div class="mx-6 mt-4 p-4 rounded-lg text-sm <?php echo strpos($msg, 'success') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
            <?php echo htmlspecialchars($msg); ?>
        </div>
    <?php endif; ?>

    <!-- Main Content -->
    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-7xl mx-auto">

            <!-- Header Card -->
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                    <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
                </div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                        <div class="mb-4 lg:mb-0 lg:flex-1">
                            <h1 class="text-xl font-light mb-1">Profile Settings</h1>
                            <p class="text-gray-300 text-sm">Update your name, image, and password</p>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-xs text-gray-300 mb-1">Profile Image</p>
                                    <div class="w-16 h-16 bg-gradient-to-br from-blue-400 to-blue-600 rounded-xl flex items-center justify-center overflow-hidden">
                                        <?php if($profile_picture == NULL){ ?>
                                        <img src="image/profile.png"
                                             alt="<?php echo htmlspecialchars($fullname); ?>"
                                             class="w-16 h-16 rounded-xl object-cover">
                                        <?php }else{ ?>
                                            <img src="../uploads/profile/<?php echo htmlspecialchars($profile_picture); ?>"
                                             alt="<?php echo htmlspecialchars($fullname); ?>"
                                             class="w-16 h-16 rounded-xl object-cover">
                                        <?php } ?>
                                             
                                             
                                    </div>
                                </div>
                                <div class="w-10 h-10 flex items-center justify-center">
                                    <i data-lucide="user" class="w-5 h-5 text-white"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Profile Form -->
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <form action="" method="POST" enctype="multipart/form-data" class="space-y-6">
                    <input type="hidden" name="_token" value="jggz3Sr4oLC5FU3bRDH6Rimfxx1uZSlQyyrscXTa" autocomplete="off">
                    <input type="hidden" name="_method" value="patch">

                    <!-- Full Name -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Full Name</label>
                                <input type="text" id="name" name="name" value="<?php echo $fullname ?>"
                                    class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200"
                                    required>
                            </div>

                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email
                                    Address</label>
                                <input type="email" id="email"  name="email" value="<?php echo $email ?>" readonly
                                    class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200"
                                    >
                            </div>
                        </div>

                    <!-- Profile Image -->
                    <div class="space-y-4">
                        <div class="flex items-center justify-between mb-4">
                            <div>
                                <h3 class="text-lg font-light text-black mb-1">Profile Image</h3>
                                <p class="text-xs text-gray-500">Upload a new profile picture</p>
                            </div>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="image" class="w-4 h-4 text-purple-600"></i>
                            </div>
                        </div>
                        <div>
                            <label for="profile_image" class="block text-sm font-medium text-gray-700 mb-2">Profile Image</label>
                            <div class="flex items-center space-x-4">
                                <div class="w-20 h-20 bg-gradient-to-br from-blue-400 to-blue-600 rounded-xl flex items-center justify-center overflow-hidden">
                                    <?php if($profile_picture ==  NULL){ ?>
                                    <img id="image-preview"
                                         src="image/profile.png"
                                         alt="Profile preview"
                                         class="w-20 h-20 object-cover">
                                    <?php }else{ ?>
                                        <img id="image-preview"
                                         src="../uploads/profile/<?php echo htmlspecialchars($profile_picture); ?>"
                                         alt="Profile preview"
                                         class="w-20 h-20 object-cover">
                                    <?php } ?>
                                </div>
                                <div class="flex-1">
                                    <input type="file" id="profile_image" name="profile_image" accept="image/*"
                                           class="w-full px-4 py-3 border <?php echo $err_image ? 'border-red-500' : 'border-gray-300'; ?> rounded-lg focus:ring-2 focus:ring-black focus:border-transparent"
                                           onchange="previewImage(this)">
                                    <p class="text-xs text-gray-500 mt-1">JPG, PNG or GIF. Max 2MB.</p>
                                    <?php if ($err_image): ?><p class="text-xs text-red-600 mt-1"><?php echo $err_image; ?></p><?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Password Change -->
                    <div class="space-y-4">
                        <div class="flex items-center justify-between mb-4">
                            <div>
                                <h3 class="text-lg font-light text-black mb-1">Change Password</h3>
                                <p class="text-xs text-gray-500">Leave blank to keep current password</p>
                            </div>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="shield" class="w-4 h-4 text-green-600"></i>
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="current_password" class="block text-sm font-medium text-gray-700 mb-2">Current Password</label>
                                <input type="password" id="current_password" name="current_password"
                                       class="w-full px-4 py-3 border <?php echo $err_cur ? 'border-red-500' : 'border-gray-300'; ?> rounded-lg focus:ring-2 focus:ring-black focus:border-transparent">
                                <?php if ($err_cur): ?><p class="text-xs text-red-600 mt-1"><?php echo $err_cur; ?></p><?php endif; ?>
                            </div>
                            <div>
                                <label for="password" class="block text-sm font-medium text-gray-700 mb-2">New Password</label>
                                <input type="password" id="password" name="password"
                                       class="w-full px-4 py-3 border <?php echo $err_new ? 'border-red-500' : 'border-gray-300'; ?> rounded-lg focus:ring-2 focus:ring-black focus:border-transparent">
                                <?php if ($err_new): ?><p class="text-xs text-red-600 mt-1"><?php echo $err_new; ?></p><?php endif; ?>
                            </div>
                        </div>
                        <div>
                            <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-2">Confirm New Password</label>
                            <input type="password" id="password_confirmation" name="password_confirmation"
                                   class="w-full px-4 py-3 border <?php echo $err_conf ? 'border-red-500' : 'border-gray-300'; ?> rounded-lg focus:ring-2 focus:ring-black focus:border-transparent">
                            <?php if ($err_conf): ?><p class="text-xs text-red-600 mt-1"><?php echo $err_conf; ?></p><?php endif; ?>
                        </div>
                    </div>

                    <!-- Submit -->
                    <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                        <div>
                            <p class="text-sm text-gray-600">Last updated: <?php echo date('M j, Y g:i A'); ?></p>
                        </div>
                        <button type="submit"
                                class="px-6 py-3 bg-black text-white font-medium rounded-lg hover:bg-gray-800 transition-colors duration-200 flex items-center">
                            <i data-lucide="save" class="w-4 h-4 mr-2"></i>
                            Save Changes
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Image Preview Script -->
        <script>
            function previewImage(input) {
                const preview = document.getElementById('image-preview');
                if (input.files && input.files[0]) {
                    const reader = new FileReader();
                    reader.onload = function (e) {
                        preview.src = e.target.result;
                    };
                    reader.readAsDataURL(input.files[0]);
                }
            }
        </script>
    </main>
</div>

<?php include 'footer.php'; ?>