<?php
include 'header.php';
?>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
            <!-- Enhanced Top Bar -->
            <header class="bg-white border-b border-gray-200">
                <div class="flex items-center justify-between px-6 py-3">
                    <div class="flex items-center">
                        <button onclick="toggleSidebar()"
                            class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                            <i data-lucide="menu" class="w-5 h-5"></i>
                        </button>
                        <div class="font-light text-lg text-black">
                            KYC Verification
                        </div>
                    </div>

                    <!-- Enhanced Right side with notifications -->
                    <div class="flex items-center space-x-3">
                        <!-- Impersonation Stop Button -->

                        <!-- Notifications -->
                        <div class="relative">
                            <button onclick="toggleNotifications()"
                                class="relative p-2 text-gray-500 hover:text-gray-700 rounded-md hover:bg-gray-100">
                                <i data-lucide="bell" class="w-5 h-5"></i>
                                <!-- Notification badge -->
                                <span id="notification-badge"
                                    class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center hidden">0</span>
                            </button>

                            <!-- Enhanced Notifications Dropdown -->
                            <div id="notifications-dropdown"
                                class="hidden absolute right-0 mt-2 w-80 bg-white rounded-lg shadow-lg border border-gray-200 z-50">
                                <div class="p-3 border-b border-gray-200">
                                    <div class="flex items-center justify-between">
                                        <h3 class="text-sm font-medium text-black">Notifications</h3>
                                        <button onclick="markAllNotificationsAsRead()"
                                            class="text-xs text-gray-500 hover:text-gray-700">Mark all read</button>
                                    </div>
                                </div>
                                <div id="notifications-list" class="max-h-64 overflow-y-auto">
                                    <!-- Notifications will be loaded here dynamically -->
                                    <div class="p-3 text-center">
                                        <div
                                            class="w-6 h-6 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-2">
                                            <i data-lucide="loader-2" class="w-3 h-3 text-gray-400 animate-spin"></i>
                                        </div>
                                        <p class="text-xs text-gray-500">Loading notifications...</p>
                                    </div>
                                </div>
                                <div class="p-3 border-t border-gray-200">
                                    <a href="https://tesla.cycloverseworld.info/notifications"
                                        class="text-xs text-black hover:text-gray-600 font-medium">View all
                                        notifications</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Enhanced Flash Messages -->




            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
                <div class="max-w-7xl mx-auto">
                    <!-- Enhanced Header -->
                    <div
                        class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                        <!-- Background Pattern -->
                        <div class="absolute inset-0 opacity-10">
                            <div
                                class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16">
                            </div>
                            <div
                                class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8">
                            </div>
                        </div>

                        <div class="relative z-10">
                            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                                <div class="mb-4 lg:mb-0 lg:flex-1">
                                    <h1 class="text-xl font-light mb-1">KYC Verification</h1>
                                    <p class="text-gray-300 text-sm">Complete your identity verification to access all
                                        features</p>
                                </div>

                                <!-- Enhanced Stats Card -->
                                <div
                                    class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                                    <div class="flex items-center justify-between">
                                        <div>
                                            <p class="text-xs text-gray-300 mb-1">Verification Status</p>
                                            <p class="text-lg font-light">Approved</p>
                                        </div>
                                        <div class="w-10 h-10 flex items-center justify-center">
                                            <i data-lucide="shield-check" class="w-5 h-5 text-white"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- KYC Approved -->
                    <div class="bg-green-50 border border-green-200 rounded-xl p-6 mb-6">
                        <div class="flex items-center">
                            <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center mr-4">
                                <i data-lucide="check-circle" class="w-6 h-6 text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-medium text-green-800">KYC Verification Approved</h3>
                                <p class="text-sm text-green-600">Your identity has been verified successfully. You have
                                    full access to all platform features.</p>
                                <p class="text-xs text-green-500 mt-1">Verified on: Aug 8, 2025 3:55 PM</p>
                            </div>
                        </div>
                    </div>

                </div>
            </main>
        </div>
    </div>

    <?php
include 'footer.php';
?>