<?php
include 'header.php';

// PAGINATION & FILTERS
$page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 9;
$offset = ($page - 1) * $per_page;

$search = trim($_GET['search'] ?? '');
$category = $_GET['category'] ?? '';
$risk_level = $_GET['risk_level'] ?? '';
$sort = $_GET['sort'] ?? 'name';

// WHERE CLAUSE
$where = [];
$params = [];
$types = '';

if ($search !== '') {
    $where[] = "(p.name LIKE ? OR p.description LIKE ? OR p.category LIKE ?)";
    $like = "%$search%";
    $params[] = $like; $params[] = $like; $params[] = $like;
    $types .= 'sss';
}

if ($category !== '') {
    $where[] = "p.category = ?";
    $params[] = $category;
    $types .= 's';
}

if ($risk_level !== '') {
    $where[] = "p.risk_level = ?";
    $params[] = $risk_level;
    $types .= 's';
}

$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// SORT MAP
$sort_map = [
    'name' => 'p.name ASC',
    'performance' => 'p.return_1y DESC',
    'nav' => 'p.nav ASC',
    'risk' => 'FIELD(p.risk_level, "conservative", "moderate", "aggressive")'
];
$order_by = $sort_map[$sort] ?? 'p.name ASC';

// TOTAL PLANS
$total_stmt = mysqli_prepare($link, "SELECT COUNT(*) FROM plans p $where_sql");
if ($params) mysqli_stmt_bind_param($total_stmt, $types, ...$params);
mysqli_stmt_execute($total_stmt);
mysqli_stmt_bind_result($total_stmt, $total_plans);
mysqli_stmt_fetch($total_stmt);
mysqli_stmt_close($total_stmt);

// FEATURED PLANS (top 3 by return)
$featured = [];
$stmt = mysqli_prepare($link, "
    SELECT id, name, category, risk_level, nav, return_1y, min_investment
    FROM plans
    ORDER BY return_1y DESC
    LIMIT 3
");
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
while ($row = mysqli_fetch_assoc($result)) {
    $featured[] = $row;
}
mysqli_stmt_close($stmt);

// ALL PLANS (with filters + pagination)
$plans = [];
$query = "
    SELECT id, name, category, risk_level, nav, return_1y, min_investment
    FROM plans p
    $where_sql
    ORDER BY $order_by
    LIMIT ? OFFSET ?
";
$types .= 'ii';
$params[] = $per_page;
$params[] = $offset;

$stmt = mysqli_prepare($link, $query);
mysqli_stmt_bind_param($stmt, $types, ...$params);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
while ($row = mysqli_fetch_assoc($result)) {
    $plans[] = $row;
}
mysqli_stmt_close($stmt);

// PAGINATION
$total_pages = max(1, ceil($total_plans / $per_page));
$showing_from = $total_plans > 0 ? ($offset + 1) : 0;
$showing_to = min($offset + $per_page, $total_plans);
?>

<!-- HTML (100% YOUR DESIGN) -->
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()" class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">Investment Plans</div>
            </div>
            
        </div>
    </header>

    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-7xl mx-auto">

            <!-- Header Card -->
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                    <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
                </div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                        <div class="mb-4 lg:mb-0 lg:flex-1">
                            <h1 class="text-xl font-light mb-1">Investment Plans</h1>
                            <p class="text-gray-300 text-sm">Discover and invest in diversified portfolios designed for growth</p>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                            <div class="flex items-center justify-between mb-3">
                                <div>
                                    <p class="text-xs text-gray-300 mb-1">Available Plans</p>
                                    <p class="text-lg font-light"><?php echo $total_plans; ?></p>
                                </div>
                                <div class="w-10 h-10 flex items-center justify-center">
                                    <i data-lucide="trending-up" class="w-5 h-5 text-white"></i>
                                </div>
                            </div>
                            <div class="flex space-x-4 text-xs">
                                <div class="flex-1 text-center">
                                    <p class="text-gray-300">Categories</p>
                                    <p class="text-white font-medium">6</p>
                                </div>
                                <div class="flex-1 text-center">
                                    <p class="text-gray-300">Featured</p>
                                    <p class="text-white font-medium">3</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 mb-6">
                <div class="p-4">
                    <button type="button" onclick="toggleFilters()" class="flex items-center justify-between w-full text-left">
                        <div class="flex items-center">
                            <i data-lucide="filter" class="w-4 h-4 text-gray-600 mr-2"></i>
                            <span class="text-sm font-medium text-black">Search & Filters</span>
                        </div>
                        <i data-lucide="chevron-down" id="filterIcon" class="w-4 h-4 text-gray-600 transition-transform duration-200"></i>
                    </button>
                </div>
                <div id="filterSection" class="hidden border-t border-gray-100">
                    <form method="GET" class="p-6">
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Search Plans</label>
                                <div class="relative">
                                    <i data-lucide="search" class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-400"></i>
                                    <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black" placeholder="Name, category, description">
                                </div>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Category</label>
                                <select name="category" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black">
                                    <option value="">All Categories</option>
                                    <option value="Tesla-Focused" <?php echo $category === 'Tesla-Focused' ? 'selected' : ''; ?>>Tesla-Focused</option>
                                    <option value="ESG" <?php echo $category === 'ESG' ? 'selected' : ''; ?>>ESG</option>
                                    <option value="Conservative" <?php echo $category === 'Conservative' ? 'selected' : ''; ?>>Conservative</option>
                                    <option value="Income" <?php echo $category === 'Income' ? 'selected' : ''; ?>>Income</option>
                                    <option value="Growth" <?php echo $category === 'Growth' ? 'selected' : ''; ?>>Growth</option>
                                    <option value="Balanced" <?php echo $category === 'Balanced' ? 'selected' : ''; ?>>Balanced</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Risk Level</label>
                                <select name="risk_level" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black">
                                    <option value="">All Risk Levels</option>
                                    <option value="conservative" <?php echo $risk_level === 'conservative' ? 'selected' : ''; ?>>Conservative</option>
                                    <option value="moderate" <?php echo $risk_level === 'moderate' ? 'selected' : ''; ?>>Moderate</option>
                                    <option value="aggressive" <?php echo $risk_level === 'aggressive' ? 'selected' : ''; ?>>Aggressive</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Sort By</label>
                                <select name="sort" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black">
                                    <option value="name" <?php echo $sort === 'name' ? 'selected' : ''; ?>>Name A-Z</option>
                                    <option value="performance" <?php echo $sort === 'performance' ? 'selected' : ''; ?>>Best Performance</option>
                                    <option value="nav" <?php echo $sort === 'nav' ? 'selected' : ''; ?>>Lowest NAV</option>
                                    <option value="risk" <?php echo $sort === 'risk' ? 'selected' : ''; ?>>Risk Level</option>
                                </select>
                            </div>
                            <div class="md:col-span-4 flex space-x-3">
                                <button type="submit" class="px-4 py-2 bg-black text-white text-sm font-medium rounded-lg hover:bg-gray-800 flex items-center">
                                    <i data-lucide="filter" class="w-4 h-4 mr-2"></i> Apply Filters
                                </button>
                                <a href="investments.php" class="px-4 py-2 border border-gray-300 text-black text-sm font-medium rounded-lg hover:bg-gray-50 flex items-center">
                                    <i data-lucide="refresh-cw" class="w-4 h-4 mr-2"></i> Clear Filters
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Featured Plans -->
            <div class="mb-8">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-light text-black">Featured Plans</h2>
                    <a href="#" class="text-xs text-black hover:text-gray-600 font-medium">View All Featured <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i></a>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php while ($plan = array_shift($featured)): ?>
                        <?php
                        $risk_badge = [
                            'conservative' => 'bg-green-100 text-green-800',
                            'moderate' => 'bg-yellow-100 text-yellow-800',
                            'aggressive' => 'bg-red-100 text-red-800'
                        ];
                        $badge = $risk_badge[$plan['risk_level']] ?? 'bg-gray-100 text-gray-800';
                        $return_class = $plan['return_1y'] > 0 ? 'text-green-600' : 'text-red-600';
                        ?>
                        <div class="group bg-white rounded-xl p-5 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                            <div class="absolute inset-0 bg-gradient-to-br from-blue-50 to-blue-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                            <div class="relative z-10">
                                <div class="flex items-start justify-between mb-4">
                                    <div class="flex-1">
                                        <h3 class="font-medium text-black text-lg mb-1"><?php echo htmlspecialchars($plan['name']); ?></h3>
                                        <p class="text-sm text-gray-600"><?php echo htmlspecialchars($plan['category']); ?></p>
                                    </div>
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium <?php echo $badge; ?>">
                                        <?php echo ucfirst($plan['risk_level']); ?>
                                    </span>
                                </div>
                                <div class="space-y-3 mb-4">
                                    <div class="flex justify-between"><span class="text-sm text-gray-500">Current NAV:</span><span class="text-sm font-medium text-black">$<?php echo number_format($plan['nav'], 4); ?></span></div>
                                    <div class="flex justify-between"><span class="text-sm text-gray-500">1Y Return:</span><span class="text-sm font-medium <?php echo $return_class; ?>"><?php echo $plan['return_1y'] >= 0 ? '+' : ''; ?><?php echo number_format($plan['return_1y'], 2); ?>%</span></div>
                                    <div class="flex justify-between"><span class="text-sm text-gray-500">Min Investment:</span><span class="text-sm font-medium text-black">$<?php echo number_format($plan['min_investment'], 2); ?></span></div>
                                </div>
                                <div class="flex items-center justify-between">
                                    <a href="investment_view.php?id=<?php echo $plan['id']; ?>" class="flex items-center text-blue-600 text-xs font-medium hover:text-blue-800">
                                        <span>View Details</span>
                                        <i data-lucide="arrow-right" class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                                    </a>
                                    <a href="investment_buy.php?id=<?php echo $plan['id']; ?>" class="px-3 py-1 bg-black text-white text-xs font-medium rounded-lg hover:bg-gray-800">Invest Now</a>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>

            <!-- All Plans -->
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-lg font-light text-black mb-1">All Investment Plans</h3>
                        <p class="text-xs text-gray-500">Showing <?php echo $showing_from; ?> to <?php echo $showing_to; ?> of <?php echo $total_plans; ?> plans</p>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php while ($plan = array_shift($plans)): ?>
                        <?php
                        $risk_badge = [
                            'conservative' => 'bg-green-100 text-green-800',
                            'moderate' => 'bg-yellow-100 text-yellow-800',
                            'aggressive' => 'bg-red-100 text-red-800'
                        ];
                        $badge = $risk_badge[$plan['risk_level']] ?? 'bg-gray-100 text-gray-800';
                        $return_class = $plan['return_1y'] > 0 ? 'text-green-600' : 'text-red-600';
                        ?>
                        <div class="group bg-gray-50 rounded-lg p-4 hover:bg-gray-100 transition-all duration-300">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1">
                                    <h4 class="font-medium text-black text-sm mb-1"><?php echo htmlspecialchars($plan['name']); ?></h4>
                                    <p class="text-xs text-gray-600"><?php echo htmlspecialchars($plan['category']); ?></p>
                                </div>
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium <?php echo $badge; ?>">
                                    <?php echo ucfirst($plan['risk_level']); ?>
                                </span>
                            </div>
                            <div class="space-y-2 mb-3">
                                <div class="flex justify-between"><span class="text-xs text-gray-500">NAV:</span><span class="text-xs font-medium text-black">$<?php echo number_format($plan['nav'], 4); ?></span></div>
                                <div class="flex justify-between"><span class="text-xs text-gray-500">Return:</span><span class="text-xs font-medium <?php echo $return_class; ?>"><?php echo $plan['return_1y'] >= 0 ? '+' : ''; ?><?php echo number_format($plan['return_1y'], 2); ?>%</span></div>
                                <div class="flex justify-between"><span class="text-xs text-gray-500">Min:</span><span class="text-xs font-medium text-black">$<?php echo number_format($plan['min_investment']); ?></span></div>
                            </div>
                            <div class="flex items-center justify-between">
                                <a href="investment_view.php?id=<?php echo $plan['id']; ?>" class="text-xs text-blue-600 hover:text-blue-800">View Details</a>
                                <a href="investment_buy.php?id=<?php echo $plan['id']; ?>" class="px-2 py-1 bg-black text-white text-xs font-medium rounded hover:bg-gray-800">Invest</a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <!-- Pagination -->
                <div class="mt-6">
                    <nav class="flex items-center justify-between">
                        <div class="flex justify-between flex-1 sm:hidden">
                            <?php if ($page > 1): ?>
                                <a href="?page=<?php echo $page - 1; ?>" class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:text-gray-500">Previous</a>
                            <?php else: ?>
                                <span class="px-4 py-2 text-sm font-medium text-gray-500 bg-white border border-gray-300 cursor-default rounded-md">Previous</span>
                            <?php endif; ?>
                            <?php if ($page < $total_pages): ?>
                                <a href="?page=<?php echo $page + 1; ?>" class="ml-3 px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:text-gray-500">Next</a>
                            <?php else: ?>
                                <span class="ml-3 px-4 py-2 text-sm font-medium text-gray-500 bg-white border border-gray-300 cursor-default rounded-md">Next</span>
                            <?php endif; ?>
                        </div>
                        <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                            <div><p class="text-sm text-gray-700">Showing <span class="font-medium"><?php echo $showing_from; ?></span> to <span class="font-medium"><?php echo $showing_to; ?></span> of <span class="font-medium"><?php echo $total_plans; ?></span> results</p></div>
                            <div>
                                <span class="relative z-0 inline-flex shadow-sm rounded-md">
                                    <?php if ($page > 1): ?>
                                        <a href="?page=<?php echo $page - 1; ?>" class="px-2 py-2 text-sm font-medium text-gray-500 bg-white border border-gray-300 rounded-l-md hover:text-gray-400">
                                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd"/></svg>
                                        </a>
                                    <?php else: ?>
                                        <span class="px-2 py-2 text-sm font-medium text-gray-500 bg-white border border-gray-300 cursor-default rounded-l-md">
                                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd"/></svg>
                                        </span>
                                    <?php endif; ?>

                                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                        <a href="?page=<?php echo $i; ?>" class="px-4 py-2 -ml-px text-sm font-medium <?php echo $i == $page ? 'text-gray-500 bg-white border border-gray-300 cursor-default' : 'text-gray-700 bg-white border border-gray-300 hover:text-gray-500'; ?>"><?php echo $i; ?></a>
                                    <?php endfor; ?>

                                    <?php if ($page < $total_pages): ?>
                                        <a href="?page=<?php echo $page + 1; ?>" class="px-2 py-2 -ml-px text-sm font-medium text-gray-500 bg-white border border-gray-300 rounded-r-md hover:text-gray-400">
                                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/></svg>
                                        </a>
                                    <?php else: ?>
                                        <span class="px-2 py-2 -ml-px text-sm font-medium text-gray-500 bg-white border border-gray-300 cursor-default rounded-r-md">
                                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/></svg>
                                        </span>
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>

        <script>
            function toggleFilters() {
                const section = document.getElementById('filterSection');
                const icon = document.getElementById('filterIcon');
                section.classList.toggle('hidden');
                icon.style.transform = section.classList.contains('hidden') ? 'rotate(0deg)' : 'rotate(180deg)';
            }
        </script>
    </main>
</div>

<?php include 'footer.php'; ?>