<?php
include 'header.php';

// -------------------------------------------------------------------
// 1. Get the plan
// -------------------------------------------------------------------
$plan_id = (int)($_GET['id'] ?? 0);
if ($plan_id <= 0) die('Invalid plan.');

$stmt = mysqli_prepare($link, "
    SELECT name, category, risk_level, nav, min_investment
    FROM plans WHERE id = ?
");
mysqli_stmt_bind_param($stmt, "i", $plan_id);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $plan_name, $plan_category, $plan_risk, $plan_nav, $plan_min);
if (!mysqli_stmt_fetch($stmt)) die('Plan not found.');
mysqli_stmt_close($stmt);

// -------------------------------------------------------------------
// 2. Get user's holdings for this plan FROM investments TABLE
// -------------------------------------------------------------------
$holding_units = 0.0;
$total_invested = 0.0;
$average_cost = 0.0;

$stmt = mysqli_prepare($link, "
    SELECT SUM(units), SUM(total_cost)
    FROM investments
    WHERE user_id = ? AND plan_id = ? AND type = 'buy' AND status = 'confirmed'
");
mysqli_stmt_bind_param($stmt, "ii", $user_id, $plan_id);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $sum_units, $sum_cost);
if (mysqli_stmt_fetch($stmt)) {
    $holding_units = $sum_units ?? 0.0;
    $total_invested = $sum_cost ?? 0.0;
    $average_cost = $holding_units > 0 ? $total_invested / $holding_units : 0.0;
}
mysqli_stmt_close($stmt);

$current_value = $holding_units * $plan_nav;

// -------------------------------------------------------------------
// 3. Process Sell (POST) – write to `investments` table
// -------------------------------------------------------------------
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sell_option = $_POST['sell_option'] ?? 'units';
    $sell_value = (float)($_POST['sell_value'] ?? 0);

    $units_to_sell = 0.0;
    $amount_to_sell = 0.0;

    if ($sell_option === 'units') {
        $units_to_sell = $sell_value;
        $amount_to_sell = $units_to_sell * $plan_nav;
    } elseif ($sell_option === 'amount') {
        $amount_to_sell = $sell_value;
        $units_to_sell = $amount_to_sell / $plan_nav;
    } elseif ($sell_option === 'all') {
        $units_to_sell = $holding_units;
        $amount_to_sell = $current_value;
    }

    // ---------- Validation ----------
    if ($units_to_sell > $holding_units) {
        $msg = "You cannot sell more than you own.";
    } elseif ($units_to_sell <= 0) {
        $msg = "Invalid sell amount.";
    } else {
        $fee = $amount_to_sell * $investment_feeRate;
        $net_proceeds = $amount_to_sell - $fee; // what the user actually receives
        $created_at = date('Y-m-d H:i:s');

        // ---------- INSERT sell record into `investments` table ----------
        $ins = mysqli_prepare($link, "
            INSERT INTO investments
                (user_id, plan_id, plan_name, plan_category, plan_risk,
                 plan_nav, plan_min_investment,
                 amount, units, fee, total_cost,
                 type, status, created_at)
            VALUES (?,?,?,?,?, ?,?,?, ?,?, ?, 'sell', 'confirmed', ?)
        ");
        mysqli_stmt_bind_param($ins, "iisssdddddds",
            $user_id, $plan_id,
            $plan_name, $plan_category, $plan_risk,
            $plan_nav, $plan_min,
            $amount_to_sell, $units_to_sell, $fee, $net_proceeds, $created_at
        );

        if (mysqli_stmt_execute($ins)) {
            // ---------- Credit user balance ----------
            $upd = mysqli_prepare($link, "UPDATE users SET balance = balance + ? WHERE id = ?");
            mysqli_stmt_bind_param($upd, "di", $net_proceeds, $user_id);
            mysqli_stmt_execute($upd);
            mysqli_stmt_close($upd);

            $msg = "Sell successful! Redirecting…";
            echo "<script>setTimeout(()=>{window.location='investment_view.php?id=$plan_id'},1500);</script>";
        } else {
            $msg = "Database error: " . mysqli_error($link);
        }
        mysqli_stmt_close($ins);
    }
}
?>
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()" class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">
                    Sell <?php echo htmlspecialchars($plan_name); ?>
                </div>
            </div>
        </div>
    </header>
    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-2xl mx-auto">
            <!-- Header Card -->
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16"></div>
                    <div class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8"></div>
                </div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                        <div class="mb-4 lg:mb-0 lg:flex-1">
                            <h1 class="text-xl font-light mb-1">Sell <?php echo htmlspecialchars($plan_name); ?></h1>
                            <p class="text-gray-300 text-sm">
                                <?php echo htmlspecialchars($plan_category); ?> • <?php echo ucfirst($plan_risk); ?> Risk
                            </p>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-xs text-gray-300 mb-1">Current NAV</p>
                                    <p class="text-lg font-light">$<?php echo number_format($plan_nav, 4); ?></p>
                                </div>
                                <div class="w-10 h-10 flex items-center justify-center">
                                    <i data-lucide="trending-down" class="w-5 h-5 text-white"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Message -->
            <?php if ($msg): ?>
                <div class="mb-4 p-3 rounded-lg <?php echo strpos($msg,'successful')!==false ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                    <?php echo htmlspecialchars($msg); ?>
                </div>
            <?php endif; ?>

            <!-- Sell Form -->
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <form method="POST" class="space-y-6">
                    <!-- Current Holdings -->
                    <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-lg p-4 border border-blue-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-blue-800">Your Holdings</span>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="pie-chart" class="w-4 h-4 text-blue-600"></i>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <p class="text-xs text-blue-700 mb-1">Total Units</p>
                                <p class="text-sm font-medium text-blue-800" id="total-units"><?php echo number_format($holding_units, 4); ?></p>
                            </div>
                            <div>
                                <p class="text-xs text-blue-700 mb-1">Current Value</p>
                                <p class="text-sm font-medium text-blue-800" id="current-value">$<?php echo number_format($current_value, 2); ?></p>
                            </div>
                            <div>
                                <p class="text-xs text-blue-700 mb-1">Average Cost</p>
                                <p class="text-sm font-medium text-blue-800" id="avg-cost">$<?php echo number_format($average_cost, 4); ?></p>
                            </div>
                            <div>
                                <p class="text-xs text-blue-700 mb-1">Total Invested</p>
                                <p class="text-sm font-medium text-blue-800">$<?php echo number_format($total_invested, 2); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Sell Options -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-3">Sell Options</label>
                        <div class="space-y-3">
                            <label class="flex items-center p-3 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50">
                                <input type="radio" name="sell_option" value="units" class="w-4 h-4 text-black" checked>
                                <div class="ml-3 flex-1">
                                    <p class="font-medium text-black text-sm">Sell by Units</p>
                                    <p class="text-xs text-gray-500">Specify the number of units to sell</p>
                                </div>
                            </label>
                            <label class="flex items-center p-3 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50">
                                <input type="radio" name="sell_option" value="amount" class="w-4 h-4 text-black">
                                <div class="ml-3 flex-1">
                                    <p class="font-medium text-black text-sm">Sell by Amount</p>
                                    <p class="text-xs text-gray-500">Specify the dollar amount to sell</p>
                                </div>
                            </label>
                            <label class="flex items-center p-3 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50">
                                <input type="radio" name="sell_option" value="all" class="w-4 h-4 text-black">
                                <div class="ml-3 flex-1">
                                    <p class="font-medium text-black text-sm">Sell All</p>
                                    <p class="text-xs text-gray-500">Sell your entire holding</p>
                                </div>
                            </label>
                        </div>
                    </div>

                    <!-- Input -->
                    <div id="sell-input-section">
                        <label for="sell_value" class="block text-sm font-medium text-gray-700 mb-2">Units to Sell</label>
                        <div class="relative">
                            <input type="number" id="sell_value" name="sell_value" step="0.0001" min="0.0001"
                                   max="<?php echo $holding_units; ?>" value=""
                                   class="w-full pl-4 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black"
                                   placeholder="0.0000" required>
                        </div>
                        <p class="text-xs text-gray-500 mt-1">Maximum: <?php echo number_format($holding_units, 4); ?> units</p>
                    </div>

                    <!-- Plan Info -->
                    <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-lg p-4 border border-blue-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-blue-800">Plan Information</span>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="info" class="w-4 h-4 text-blue-600"></i>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-4">
                            <div><p class="text-xs text-blue-700 mb-1">Current NAV</p><p class="text-sm font-medium text-blue-800">$<?php echo number_format($plan_nav, 4); ?></p></div>
                            <div><p class="text-xs text-blue-700 mb-1">1Y Return</p><p class="text-sm font-medium text-green-600">+9.23%</p></div>
                            <div><p class="text-xs text-blue-700 mb-1">Management Fee</p><p class="text-sm font-medium text-blue-800">0.85%</p></div>
                            <div><p class="text-xs text-blue-700 mb-1">Risk Level</p><p class="text-sm font-medium text-blue-800"><?php echo ucfirst($plan_risk); ?></p></div>
                        </div>
                    </div>

                    <!-- Breakdown -->
                    <div class="bg-gradient-to-br from-red-50 to-red-100 rounded-lg p-4 border border-red-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-red-800">Sale Breakdown</span>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="calculator" class="w-4 h-4 text-red-600"></i>
                            </div>
                        </div>
                        <div class="space-y-2">
                            <div class="flex justify-between"><span class="text-xs text-red-700">Sale Amount:</span><span id="sale-amount" class="text-xs font-medium text-red-800">$0.00</span></div>
                            <div class="flex justify-between"><span class="text-xs text-red-700">Units to Sell:</span><span id="units-to-sell" class="text-xs font-medium text-red-800">0.0000</span></div>
                            <div class="flex justify-between"><span class="text-xs text-red-700">Processing Fee (<?= number_format($investment_feeRate * 100, 2) ?>%):</span><span id="processing-fee" class="text-xs font-medium text-red-800">$0.00</span></div>
                            <div class="border-t border-red-300 pt-2 flex justify-between font-bold">
                                <span class="text-red-800">You'll Receive:</span>
                                <span id="net-amount" class="text-red-900">$0.00</span>
                            </div>
                        </div>
                    </div>

                    <!-- Profit/Loss -->
                    <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg p-4 border border-gray-200">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-xs font-medium text-gray-800">Profit/Loss</span>
                            <div class="w-8 h-8 flex items-center justify-center">
                                <i data-lucide="trending-up" class="w-4 h-4 text-gray-600"></i>
                            </div>
                        </div>
                        <div class="space-y-2">
                            <div class="flex justify-between"><span class="text-xs text-gray-700">Average Cost:</span><span class="text-xs font-medium text-gray-800">$<?php echo number_format($average_cost, 4); ?></span></div>
                            <div class="flex justify-between"><span class="text-xs text-gray-700">Current NAV:</span><span class="text-xs font-medium text-gray-800">$<?php echo number_format($plan_nav, 4); ?></span></div>
                            <div class="flex justify-between"><span class="text-xs text-gray-700">Gain/Loss:</span><span id="gain-loss" class="text-xs font-medium">$0.00 (0.00%)</span></div>
                        </div>
                    </div>

                    <button type="submit" id="sellBtn"
                            class="w-full bg-black text-white py-3 rounded-lg font-medium hover:bg-gray-800 flex items-center justify-center">
                        <i data-lucide="minus" class="w-4 h-4 mr-2"></i> Sell Investment
                    </button>
                </form>
            </div>
        </div>

        <!-- JavaScript -->
        <script>
            const sellValueInput = document.getElementById('sell_value');
            const saleAmount = document.getElementById('sale-amount');
            const unitsToSellEl = document.getElementById('units-to-sell');
            const processingFee = document.getElementById('processing-fee');
            const netAmount = document.getElementById('net-amount');
            const gainLoss = document.getElementById('gain-loss');
            const sellBtn = document.getElementById('sellBtn');

            const holdingUnits = <?php echo $holding_units; ?>;
            const avgCost = <?php echo $average_cost; ?>;
            const nav = <?php echo $plan_nav; ?>;
            const maxValue = holdingUnits * nav;
            const feeRate = <?php echo $investment_feeRate; ?>;

            function updateCalc() {
                const option = document.querySelector('input[name="sell_option"]:checked').value;
                let inputVal = parseFloat(sellValueInput.value) || 0;
                let units = 0, amount = 0;

                if (option === 'units') {
                    units = Math.min(inputVal, holdingUnits);
                    amount = units * nav;
                } else if (option === 'amount') {
                    amount = Math.min(inputVal, maxValue);
                    units = amount / nav;
                } else if (option === 'all') {
                    units = holdingUnits;
                    amount = maxValue;
                }

                const fee = amount * feeRate;
                const net = amount - fee;
                const costBasis = units * avgCost;
                const gain = amount - costBasis;
                const gainPct = costBasis > 0 ? (gain / costBasis) * 100 : 0;

                saleAmount.textContent = '$' + amount.toFixed(2);
                unitsToSellEl.textContent = units.toFixed(4);
                processingFee.textContent = '$' + fee.toFixed(2);
                netAmount.textContent = '$' + net.toFixed(2);
                gainLoss.textContent = `$${gain.toFixed(2)} (${gainPct.toFixed(2)}%)`;
                gainLoss.className = `text-xs font-medium ${gain >= 0 ? 'text-green-600' : 'text-red-600'}`;

                // Button state
                if (units <= 0 || units > holdingUnits) {
                    sellBtn.disabled = true;
                    sellBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    sellBtn.innerHTML = '<i data-lucide="alert-circle" class="w-4 h-4 mr-2"></i> Invalid Amount';
                } else {
                    sellBtn.disabled = false;
                    sellBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    sellBtn.innerHTML = '<i data-lucide="minus" class="w-4 h-4 mr-2"></i> Sell Investment';
                }
            }

            document.querySelectorAll('input[name="sell_option"]').forEach(radio => {
                radio.addEventListener('change', () => {
                    const label = document.querySelector('#sell-input-section label');
                    const maxText = document.querySelector('#sell-input-section p');

                    if (radio.value === 'units') {
                        label.textContent = 'Units to Sell';
                        sellValueInput.placeholder = '0.0000';
                        sellValueInput.step = '0.0001';
                        sellValueInput.max = holdingUnits;
                        maxText.textContent = `Maximum: ${holdingUnits.toFixed(4)} units`;
                        sellValueInput.value = '';
                    } else if (radio.value === 'amount') {
                        label.textContent = 'Amount to Sell';
                        sellValueInput.placeholder = '0.00';
                        sellValueInput.step = '0.01';
                        sellValueInput.max = maxValue;
                        maxText.textContent = `Maximum: $${maxValue.toFixed(2)}`;
                        sellValueInput.value = '';
                    } else if (radio.value === 'all') {
                        label.textContent = 'Sell All Holdings';
                        sellValueInput.value = maxValue.toFixed(2);
                        sellValueInput.disabled = true;
                        maxText.textContent = `Selling all ${holdingUnits.toFixed(4)} units worth $${maxValue.toFixed(2)}`;
                    } else {
                        sellValueInput.disabled = false;
                    }
                    updateCalc();
                });
            });

            sellValueInput.addEventListener('input', updateCalc);
            updateCalc();
        </script>
    </main>
</div>
<?php include 'footer.php'; ?>