<?php
include 'header.php';
$plan_id = (int)($_GET['id'] ?? 0);
if ($plan_id <= 0) die('Invalid plan.');

// ------------------------------------------------------------------
// 1. Fetch plan details
// ------------------------------------------------------------------
$stmt = mysqli_prepare($link, "
    SELECT name, category, risk_level, nav, min_investment
    FROM plans WHERE id = ?
");
mysqli_stmt_bind_param($stmt, "i", $plan_id);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $plan_name, $plan_category, $plan_risk, $plan_nav, $plan_min);
if (!mysqli_stmt_fetch($stmt)) die('Plan not found.');
mysqli_stmt_close($stmt);

// ------------------------------------------------------------------
// 2. Process POST (buy investment)
// ------------------------------------------------------------------
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = (float)($_POST['amount'] ?? 0);
    $fee = $amount * $investment_feeRate; // $investment_feeRate comes from header.php
    $total = $amount + $fee;
    $units = $plan_nav > 0 ? $amount / $plan_nav : 0;

    if ($amount < $plan_min) {
        $msg = "Minimum investment is \${$plan_min}.";
    } elseif ($total > $balance) {
        $msg = "Insufficient balance.";
    } else {
        $created_at = date('Y-m-d H:i:s');

        // ----------------------------------------------------------
        // INSERT INTO **investments** table (not transactions)
        // ----------------------------------------------------------
        $ins = mysqli_prepare($link, "
            INSERT INTO investments
                (user_id, plan_id, plan_name, plan_category, plan_risk,
                 plan_nav, plan_min_investment,
                 amount, units, fee, total_cost,
                 type, status, created_at)
            VALUES (?,?,?,?,?, ?,?,?, ?,?, ?, 'buy', 'Pending', ?)
        ");
        mysqli_stmt_bind_param($ins, "iisssdddddds",
            $user_id, $plan_id,
            $plan_name, $plan_category, $plan_risk,
            $plan_nav, $plan_min,
            $amount, $units, $fee, $total, $created_at
        );

        if (mysqli_stmt_execute($ins)) {
            // ----------------------------------------------------------
            // Deduct from user balance
            // ----------------------------------------------------------
            $new_balance = $balance - $total;
            $upd = mysqli_prepare($link, "UPDATE users SET balance = ? WHERE id = ?");
            mysqli_stmt_bind_param($upd, "di", $new_balance, $user_id);
            mysqli_stmt_execute($upd);
            mysqli_stmt_close($upd);

            $msg = "Investment successful! Redirecting…";
            echo "<script>setTimeout(()=>{window.location='investments.php'},1500);</script>";
        } else {
            $msg = "Database error: " . mysqli_error($link);
        }
        mysqli_stmt_close($ins);
    }
}
?>
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()" class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">
                    Buy <?php echo htmlspecialchars($plan_name); ?>
                </div>
            </div>
        </div>
    </header>
    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-2xl mx-auto">
            <!-- Header Card -->
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16"></div>
                    <div class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8"></div>
                </div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                        <div class="mb-4 lg:mb-0 lg:flex-1">
                            <h1 class="text-xl font-light mb-1">Buy <?php echo htmlspecialchars($plan_name); ?></h1>
                            <p class="text-gray-300 text-sm">
                                <?php echo htmlspecialchars($plan_category); ?> • <?php echo ucfirst($plan_risk); ?> Risk
                            </p>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-xs text-gray-300 mb-1">Current NAV</p>
                                    <p class="text-lg font-light">$<?php echo number_format($plan_nav,4); ?></p>
                                </div>
                                <div class="w-10 h-10 flex items-center justify-center">
                                    <i data-lucide="trending-up" class="w-5 h-5 text-white"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Message -->
            <?php if ($msg): ?>
                <div class="mb-4 p-3 rounded-lg <?php echo strpos($msg,'successful')!==false ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                    <?php echo htmlspecialchars($msg); ?>
                </div>
            <?php endif; ?>

            <!-- Form -->
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <form method="POST" class="space-y-6">
                    <div>
                        <label for="amount" class="block text-sm font-medium text-gray-700 mb-2">Investment Amount</label>
                        <div class="relative">
                            <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500">$</span>
                            <input type="number" id="amount" name="amount" step="0.01"
                                   min="<?php echo $plan_min; ?>" max="100000"
                                   class="w-full pl-8 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black"
                                   placeholder="0.00" required>
                        </div>
                        <p class="text-xs text-gray-500 mt-1">Minimum: $<?php echo number_format($plan_min,2); ?></p>
                    </div>

                    <!-- Breakdown -->
                    <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-lg p-4 border border-green-200">
                        <div class="flex justify-between mb-3">
                            <span class="text-xs font-medium text-green-800">Investment Breakdown</span>
                            <i data-lucide="calculator" class="w-4 h-4 text-green-600"></i>
                        </div>
                        <div class="space-y-2 text-xs">
                            <div class="flex justify-between"><span class="text-green-700">Amount:</span><span id="investment-amount">$0.00</span></div>
                            <div class="flex justify-between"><span class="text-green-700">Units:</span><span id="units-to-buy">0.0000</span></div>
                            <div class="flex justify-between"><span class="text-green-700">Fee (<?= number_format($investment_feeRate * 100, 2) ?>%):</span><span id="processing-fee">$0.00</span></div>
                            <div class="border-t border-green-300 pt-2 flex justify-between font-bold">
                                <span class="text-green-800">Total:</span>
                                <span id="total-cost" class="text-green-900">$0.00</span>
                            </div>
                        </div>
                    </div>

                    <!-- Wallet -->
                    <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg p-4 border border-gray-200">
                        <div class="flex justify-between mb-3">
                            <span class="text-xs font-medium text-gray-800">Wallet Balance</span>
                            <i data-lucide="wallet" class="w-4 h-4 text-gray-600"></i>
                        </div>
                        <div class="text-xs">
                            <div class="flex justify-between"><span class="text-gray-700">Available:</span><span class="font-medium">$<?php echo number_format($balance,2); ?></span></div>
                            <div class="flex justify-between mt-1"><span class="text-gray-700">After Purchase:</span><span id="remaining-balance">$<?php echo number_format($balance,2); ?></span></div>
                        </div>
                    </div>

                    <button type="submit" id="buyBtn"
                            class="w-full bg-black text-white py-3 rounded-lg font-medium hover:bg-gray-800 flex items-center justify-center">
                        <i data-lucide="plus" class="w-4 h-4 mr-2"></i> Buy Investment
                    </button>
                </form>
            </div>
        </div>

        <!-- JavaScript – Real-time calculation -->
        <script>
            const amountInput = document.getElementById('amount');
            const investAmt = document.getElementById('investment-amount');
            const unitsEl = document.getElementById('units-to-buy');
            const feeEl = document.getElementById('processing-fee');
            const totalEl = document.getElementById('total-cost');
            const remainEl = document.getElementById('remaining-balance');
            const buyBtn = document.getElementById('buyBtn');

            const balance = <?php echo $balance; ?>;
            const nav = <?php echo $plan_nav; ?>;
            const minInv = <?php echo $plan_min; ?>;
            const feeRate = <?php echo $investment_feeRate; ?>;

            function updateCalc() {
                const amt = parseFloat(amountInput.value) || 0;
                const units = nav > 0 ? amt / nav : 0;
                const fee = amt * feeRate;
                const total = amt + fee;
                const remain = balance - total;

                investAmt.textContent = '$' + amt.toFixed(2);
                unitsEl.textContent = units.toFixed(4);
                feeEl.textContent = '$' + fee.toFixed(2);
                totalEl.textContent = '$' + total.toFixed(2);
                remainEl.textContent = '$' + remain.toFixed(2);

                if (total > balance || amt < minInv || amt <= 0) {
                    buyBtn.disabled = true;
                    buyBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    buyBtn.innerHTML = '<i data-lucide="alert-circle" class="w-4 h-4 mr-2"></i> Insufficient Funds or Below Minimum';
                } else {
                    buyBtn.disabled = false;
                    buyBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    buyBtn.innerHTML = '<i data-lucide="plus" class="w-4 h-4 mr-2"></i> Buy Investment';
                }
            }

            amountInput.addEventListener('input', updateCalc);
            updateCalc(); // Initial calculation
        </script>
    </main>
</div>
<?php include 'footer.php'; ?>