<?php
    include 'session.php';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="jggz3Sr4oLC5FU3bRDH6Rimfxx1uZSlQyyrscXTa">

    <title>Tesla Investment</title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon"
        href="../images/logo.png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <!-- Scripts -->
    <link rel="preload" as="style" href="css/app-1OgqAOn0.css" />
    <link rel="modulepreload" as="script" href="js/app-FoMq_5CK.js" />
    <link rel="stylesheet" href="css/app-1OgqAOn0.css" />
    <script type="module" src="js/app-FoMq_5CK.js"></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            const isOpen = sidebar.classList.contains('translate-x-0');

            if (isOpen) {
                sidebar.classList.remove('translate-x-0');
                sidebar.classList.add('-translate-x-full');
                overlay.classList.add('hidden');
            } else {
                sidebar.classList.remove('-translate-x-full');
                sidebar.classList.add('translate-x-0');
                overlay.classList.remove('hidden');
            }
        }

    </script>
</head>

<body class="font-sans antialiased bg-white">
    <div class="min-h-screen flex">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-[9998] lg:hidden hidden"
            onclick="toggleSidebar()"></div>

        <!-- Enhanced Sidebar -->
        <div id="sidebar"
            class="fixed inset-y-0 left-0 z-[9999] w-72 bg-black shadow-2xl transform -translate-x-full transition-transform duration-300 ease-in-out lg:translate-x-0">
            <div class="flex flex-col h-full">
                <!-- Enhanced Logo Section -->
                <div class="flex items-center justify-between h-16 px-6 border-b border-gray-800">
                    <div class="flex items-center">
                        <img src="../images/logo-white.png"
                            alt="Tesla Investment" class="h-6 w-auto mr-3 filter brightness-0 invert">
                    </div>
                    <button onclick="toggleSidebar()"
                        class="lg:hidden text-gray-400 hover:text-white p-1.5 rounded-md hover:bg-gray-800">
                        <i data-lucide="x" class="w-4 h-4"></i>
                    </button>
                </div>

                <!-- Enhanced User Profile Section -->
                <div class="px-6 py-4 border-b border-gray-800">
                    <div class="flex items-center space-x-3">
                        <div class="relative">
                            <div
                                class="w-12 h-12 bg-gradient-to-br from-blue-400 to-blue-600 rounded-xl flex items-center justify-center">
                                <?php if($profile_picture == NULL){ ?>
                                <img src="image/profile.png"
                                    alt="Test User" class="w-12 h-12 rounded-xl object-cover">
                                <?php }else{ ?>
                                 <img src="../uploads/profile/<?php echo htmlspecialchars($profile_picture); ?>"
                                    alt="Test User" class="w-12 h-12 rounded-xl object-cover">
                                <?php } ?>
                            </div>
                            <!-- KYC Status Badge -->
                            <div
                                class="absolute -bottom-1 -right-1 w-5 h-5 bg-green-500 rounded-full flex items-center justify-center border-2 border-black">
                                <i data-lucide="check" class="w-2.5 h-2.5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-white truncate"><?php echo $fullname ?></p>
                            <p class="text-xs text-gray-400 truncate"><?php echo $email ?></p>
                            <!--<div class="flex items-center mt-1">-->
                            <!--    <span-->
                            <!--        class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-green-900 text-green-300">-->
                            <!--        <i data-lucide="shield-check" class="w-3 h-3 mr-1"></i>-->
                            <!--        KYC Verified-->
                            <!--    </span>-->
                            <!--</div>-->
                        </div>
                    </div>
                </div>

                <!-- Enhanced Navigation -->
                <nav class="flex-1 px-4 py-4 space-y-1 overflow-y-auto">
                    <!-- Dashboard -->
                    <a href="dashboard.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 bg-white text-black">
                        <i data-lucide="layout-dashboard" class="w-4 h-4 mr-3 text-black"></i>
                        <span>Dashboard</span>
                    </a>

                    <!-- Wallet -->
                    <a href="wallet.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="wallet" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Wallet</span>
                    </a>

                    <!-- Investments -->
                    <a href="investments.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="trending-up" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Investments</span>
                    </a>

                    <!-- Stocks -->
                    <a href="stocks.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="bar-chart-3" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Stocks</span>
                    </a>

                    <!-- Portfolio -->
                    <a href="portfolio.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="pie-chart" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Portfolio</span>
                    </a>
                    
                     <!-- Purchase History -->
                    <a href="transactions_history.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="receipt" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Transactions</span>
                    </a>


                    <!-- Investment Dashboard -->
                    <a href="investment.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="bar-chart-3" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Investment Dashboard</span>
                    </a>

                    <!-- Browse Cars -->
                    <a href="cars.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="car" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Inventory</span>
                    </a>

                    <!-- Purchase History -->
                    <a href="history.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="receipt" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Orders</span>
                    </a>

                    <!-- Profile -->
                    <a href="profile.php"
                        class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-gray-300 hover:bg-gray-800 hover:text-white">
                        <i data-lucide="user" class="w-4 h-4 mr-3 text-gray-400"></i>
                        <span>Account</span>
                    </a>

                 
                    <!-- Divider -->
                    <div class="border-t border-gray-800 pt-4 mt-4">
                        <!-- Support -->
                        <a href="support.php"
                            class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-300 hover:bg-gray-800 hover:text-white transition-all duration-200">
                            <i data-lucide="help-circle" class="w-4 h-4 mr-3 text-gray-400"></i>
                            <span>Support</span>
                        </a>
                    </div>
                </nav>

                <!-- Enhanced User Menu -->
                <div class="p-4 border-t border-gray-800">
                    <div class="flex items-center justify-between">
                        <span class="text-sm font-medium text-gray-300">Logout</span>
                        <form method="POST" action="logout.php" class="inline">
                            <input type="hidden" name="_token" value="jggz3Sr4oLC5FU3bRDH6Rimfxx1uZSlQyyrscXTa"
                                autocomplete="off"> <button type="submit"
                                class="flex items-center text-sm font-medium text-red-400 hover:text-red-300 transition-colors p-2 rounded-lg hover:bg-gray-800"
                                title="Sign Out">
                                <i data-lucide="log-out" class="w-4 h-4"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>