<!-- Enhanced Mobile Bottom Navigation -->
    <div class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 lg:hidden z-50 shadow-2xl">
        <div class="flex justify-around px-3 py-2">
            <!-- Dashboard -->
            <a href="dashboard.php"
                class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-white bg-gradient-to-br from-blue-500 to-blue-600 shadow-lg scale-105">
                <div class="relative">
                    <i data-lucide="layout-dashboard" class="w-5 h-5 mb-1"></i>
                    <div class="absolute -top-1 -right-1 w-1.5 h-1.5 bg-white rounded-full"></div>
                </div>
                <span class="text-xs font-semibold">Home</span>
            </a>

            <!-- Wallet -->
            <a href="wallet.php"
                class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-gray-500 hover:text-green-600 hover:bg-green-50">
                <div class="relative">
                    <i data-lucide="wallet" class="w-5 h-5 mb-1"></i>
                </div>
                <span class="text-xs font-semibold">Wallet</span>
            </a>

            <!-- Investments -->
            <a href="investments.php"
                class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-gray-500 hover:text-purple-600 hover:bg-purple-50">
                <div class="relative">
                    <i data-lucide="trending-up" class="w-5 h-5 mb-1"></i>
                </div>
                <span class="text-xs font-semibold">Invest</span>
            </a>

            <!-- Stocks -->
            <a href="stocks.php"
                class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-gray-500 hover:text-orange-600 hover:bg-orange-50">
                <div class="relative">
                    <i data-lucide="bar-chart-3" class="w-5 h-5 mb-1"></i>
                </div>
                <span class="text-xs font-semibold">Stocks</span>
            </a>

            <!-- Portfolio -->
            <a href="portfolio.php"
                class="flex flex-col items-center py-1.5 px-3 rounded-xl transition-all duration-300 text-gray-500 hover:text-red-600 hover:bg-red-50">
                <div class="relative">
                    <i data-lucide="pie-chart" class="w-5 h-5 mb-1"></i>
                </div>
                <span class="text-xs font-semibold">Portfolio</span>
            </a>
        </div>
    </div>

    <script>
        // Initialize Lucide icons
        lucide.createIcons();

        // Close dropdowns when clicking outside
        document.addEventListener('click', function (event) {
            const notificationsDropdown = document.getElementById('notifications-dropdown');

            if (!event.target.closest('#notifications-dropdown') && !event.target.closest('button[onclick="toggleNotifications()"]')) {
                notificationsDropdown.classList.add('hidden');
            }
        });

        function toggleNotifications() {
            const dropdown = document.getElementById('notifications-dropdown');
            dropdown.classList.toggle('hidden');

            if (!dropdown.classList.contains('hidden')) {
                loadNotifications();
            }
        }

        function markAllNotificationsAsRead() {
            fetch('https://tesla.cycloverseworld.info/notifications/mark-all-read', {
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': 'jggz3Sr4oLC5FU3bRDH6Rimfxx1uZSlQyyrscXTa',
                    'Content-Type': 'application/json',
                },
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        loadNotifications();
                        updateNotificationBadge();
                    }
                })
                .catch(error => console.error('Error:', error));
        }

        function loadNotifications() {
            fetch('https://tesla.cycloverseworld.info/notifications/api')
                .then(response => response.json())
                .then(data => {
                    const notificationsList = document.getElementById('notifications-list');

                    if (data.notifications.length === 0) {
                        notificationsList.innerHTML = `
                            <div class="p-3 text-center">
                                <div class="w-6 h-6 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-2">
                                    <i data-lucide="bell" class="w-3 h-3 text-gray-400"></i>
                                </div>
                                <p class="text-xs text-gray-500">No notifications</p>
                            </div>
                        `;
                    } else {
                        notificationsList.innerHTML = data.notifications.map(notification => `
                            <div class="p-3 border-b border-gray-100 hover:bg-gray-50 ${notification.is_read ? 'opacity-60' : ''}">
                                <div class="flex items-start">
                                    <div class="w-6 h-6 bg-${notification.color}-500 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                                        <i data-lucide="${notification.icon}" class="w-3 h-3 text-white"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-xs font-medium text-black">${notification.title}</p>
                                        <p class="text-xs text-gray-500">${notification.message}</p>
                                        <p class="text-xs text-gray-400 mt-1">${notification.formatted_time}</p>
                                    </div>
                                </div>
                            </div>
                        `).join('');
                    }

                    // Re-initialize Lucide icons for new content
                    lucide.createIcons();
                })
                .catch(error => {
                    console.error('Error loading notifications:', error);
                    const notificationsList = document.getElementById('notifications-list');
                    notificationsList.innerHTML = `
                        <div class="p-3 text-center">
                            <div class="w-6 h-6 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-2">
                                <i data-lucide="alert-circle" class="w-3 h-3 text-red-400"></i>
                            </div>
                            <p class="text-xs text-red-500">Failed to load notifications</p>
                        </div>
                    `;
                    lucide.createIcons();
                });
        }

        function updateNotificationBadge() {
            fetch('https://tesla.cycloverseworld.info/notifications/unread-count')
                .then(response => response.json())
                .then(data => {
                    const badge = document.getElementById('notification-badge');
                    if (data.count > 0) {
                        badge.textContent = data.count;
                        badge.classList.remove('hidden');
                    } else {
                        badge.classList.add('hidden');
                    }
                })
                .catch(error => console.error('Error updating badge:', error));
        }

        // Load notifications and update badge on page load
        document.addEventListener('DOMContentLoaded', function () {
            loadNotifications();
            updateNotificationBadge();

            // Update every 30 seconds
            setInterval(() => {
                updateNotificationBadge();
            }, 30000);
        });
    </script>

    <!-- Real-time Stock Updates -->
    <link rel="stylesheet" href="css/stock-animations.css">
    <script src="js/stock-updates.js"></script>
    <script src="js/market-overview.js"></script>
    <script src="js/portfolio-updates.js"></script>
</body>

</html>