<?php
    include 'header.php';
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Store deposit details in session
    $_SESSION['deposit_details'] = [
        'amount' => floatval($_POST['amount']),
        'coin' => htmlspecialchars($_POST['coin']),
        'receiving_amount' => floatval($_POST['amount']) + $deposits_charge,
        'method' => htmlspecialchars($_POST['payment_method_id'])
    ];
    
    // Redirect to manual payment page
    echo "<script>window.location.href = 'confirm.php';</script>";exit;
}

?>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
            <!-- Enhanced Top Bar -->
            <header class="bg-white border-b border-gray-200">
                <div class="flex items-center justify-between px-6 py-3">
                    <div class="flex items-center">
                        <button onclick="toggleSidebar()"
                            class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                            <i data-lucide="menu" class="w-5 h-5"></i>
                        </button>
                        <div class="font-light text-lg text-black">
                            Deposit Funds
                        </div>
                    </div>
                </div>
            </header>
            <!-- Enhanced Flash Messages -->


            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
                <div class="max-w-2xl mx-auto">
                    <!-- Enhanced Header -->
                    <div
                        class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                        <!-- Background Pattern -->
                        <div class="absolute inset-0 opacity-10">
                            <div
                                class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16">
                            </div>
                            <div
                                class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8">
                            </div>
                        </div>

                        <div class="relative z-10">
                            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                                <div class="mb-4 lg:mb-0 lg:flex-1">
                                    <h1 class="text-xl font-light mb-1">Deposit Funds</h1>
                                    <p class="text-gray-300 text-sm">Add money to your wallet using your preferred
                                        payment method</p>
                                </div>

                                <!-- Enhanced Balance Card -->
                                <div
                                    class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                                    <div class="flex items-center justify-between">
                                        <div>
                                            <p class="text-xs text-gray-300 mb-1">Current Balance</p>
                                            <p class="text-lg font-light">$<?php echo number_format($balance, 2) ?></p>
                                        </div>
                                        <div class="w-10 h-10 flex items-center justify-center">
                                            <i data-lucide="wallet" class="w-5 h-5 text-white"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Enhanced Deposit Form -->
                    <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                        <form action="" method="POST"
                            class="space-y-6">
                           
                            <!-- Amount Input -->
                            <div>
                                <label for="amount" class="block text-sm font-medium text-gray-700 mb-2">Deposit
                                    Amount</label>
                                <div class="relative">
                                    <span
                                        class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500">$</span>
                                    <input type="number" id="amount" name="amount" step="0.01" min="1" max="100000"
                                        value=""
                                        class="w-full pl-8 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200"
                                        placeholder="0.00" required>
                                </div>
                            </div>

                            <!-- Payment Method Selection -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-3">Payment Method</label>
                                <div class="space-y-3">
                                    <label
                                        class="flex items-center p-4 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50 transition-all duration-200 group">
                                        <input type="radio" name="payment_method_id" value="BTC"
                                            class="w-4 h-4 text-black border-gray-300 focus:ring-black" required>
                                        <div class="ml-3 flex items-center flex-1">
                                            <img src="image/ORlsQwv0PZBkspRvbK9uU5RRxhcyGuj2yC1MtOrQ.png"
                                                alt="Bitcoin" class="w-8 h-8 mr-3">
                                            <div class="flex-1">
                                                <p class="font-medium text-black text-sm">Bitcoin</p>
                                                <p class="text-xs text-gray-500"></p>
                                            </div>
                                            <div
                                                class="w-6 h-6 flex items-center justify-center group-hover:scale-110 transition-transform duration-200">
                                                <i data-lucide="arrow-right"
                                                    class="w-4 h-4 text-gray-400 group-hover:text-gray-600"></i>
                                            </div>
                                        </div>
                                    </label>
                                    <label
                                        class="flex items-center p-4 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50 transition-all duration-200 group">
                                        <input type="radio" name="payment_method_id" value="ETH"
                                            class="w-4 h-4 text-black border-gray-300 focus:ring-black" required>
                                        <div class="ml-3 flex items-center flex-1">
                                            <img src="image/D8Kmhhgnkh2f4M8kCLnMRnacE2G3Tq0oX97LkhsG.png"
                                                alt="Ethereum" class="w-8 h-8 mr-3">
                                            <div class="flex-1">
                                                <p class="font-medium text-black text-sm">Ethereum</p>
                                                <p class="text-xs text-gray-500"></p>
                                            </div>
                                            <div
                                                class="w-6 h-6 flex items-center justify-center group-hover:scale-110 transition-transform duration-200">
                                                <i data-lucide="arrow-right"
                                                    class="w-4 h-4 text-gray-400 group-hover:text-gray-600"></i>
                                            </div>
                                        </div>
                                    </label>
                                    <label
                                        class="flex items-center p-4 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50 transition-all duration-200 group">
                                        <input type="radio" name="payment_method_id" value="LTC"
                                            class="w-4 h-4 text-black border-gray-300 focus:ring-black" required>
                                        <div class="ml-3 flex items-center flex-1">
                                            <img src="https://zengo.com/wp-content/uploads/USDT-TRC20.png"
                                                alt="USDT trc20" class="w-8 h-8 mr-3">
                                            <div class="flex-1">
                                                <p class="font-medium text-black text-sm">USDT trc20</p>
                                                <p class="text-xs text-gray-500"></p>
                                            </div>
                                            <div
                                                class="w-6 h-6 flex items-center justify-center group-hover:scale-110 transition-transform duration-200">
                                                <i data-lucide="arrow-right"
                                                    class="w-4 h-4 text-gray-400 group-hover:text-gray-600"></i>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>

                            <!-- Enhanced Fee Information -->
                            <div
                                class="bg-gradient-to-br from-green-50 to-green-100 rounded-lg p-4 border border-green-200">
                                <div class="flex items-center justify-between mb-3">
                                    <span class="text-xs font-medium text-green-800">Fee Breakdown</span>
                                    <div class="w-8 h-8 flex items-center justify-center">
                                        <i data-lucide="calculator" class="w-4 h-4 text-green-600"></i>
                                    </div>
                                </div>
                                <div class="space-y-2">
                                    <div class="flex items-center justify-between">
                                        <span class="text-xs text-green-700">Deposit Amount:</span>
                                        <span class="text-xs font-medium text-green-800"
                                            id="deposit-amount">$0.00</span>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <span class="text-xs text-green-700">Processing Fee:</span>
                                        <span class="text-xs font-medium text-green-800"
                                            id="processing-fee">$0.00</span>
                                    </div>
                                    <div class="border-t border-green-300 pt-2">
                                        <div class="flex items-center justify-between">
                                            <span class="text-xs font-semibold text-green-800">Total Amount:</span>
                                            <span class="text-xs font-bold text-green-900"
                                                id="total-amount">$0.00</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="pt-4">
                                <button type="submit"
                                    class="w-full bg-black text-white py-3 px-6 rounded-lg font-medium hover:bg-gray-800 transition-colors duration-200 flex items-center justify-center">
                                    <i data-lucide="plus" class="w-4 h-4 mr-2"></i>
                                    Deposit Funds
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <script>
                    // Fee calculation logic
                    const amountInput = document.getElementById('amount');
                    const depositAmount = document.getElementById('deposit-amount');
                    const processingFee = document.getElementById('processing-fee');
                    const totalAmount = document.getElementById('total-amount');

                    function updateFeeCalculation() {
                        const amount = parseFloat(amountInput.value) || 0;
                        const fee = <?php echo $deposits_charge ?>; // Processing fee is 0
                        const total = amount + fee;

                        depositAmount.textContent = `$${amount.toFixed(2)}`;
                        processingFee.textContent = `$${fee.toFixed(2)}`;
                        totalAmount.textContent = `$${total.toFixed(2)}`;
                    }

                    amountInput.addEventListener('input', updateFeeCalculation);
                    updateFeeCalculation();
                </script>
            </main>
        </div>
    </div>

    <?php
    include 'footer.php';
?>