<?php
include 'header.php';

// -------------------------------------------------
// 1. WALLET BALANCE (already available as $balance)
// -------------------------------------------------

// -------------------------------------------------
// 2. TESLA VEHICLES COUNT (from orders table)
// -------------------------------------------------
$tesla_count = 0;
$stmt = mysqli_prepare($link, "SELECT COUNT(*) FROM orders WHERE user_id = ?");
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $tesla_count);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

// -------------------------------------------------
// 3. INVESTMENT HOLDINGS VALUE (from investments table)
// -------------------------------------------------
$investment_value = 0.0;
$stmt = mysqli_prepare($link, "
    SELECT SUM(i.units * i.plan_nav) AS current_value
    FROM investments i
    WHERE i.user_id = ?
      AND i.type = 'buy'
");
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $investment_value);
mysqli_stmt_fetch($stmt);
$investment_value = (float)$investment_value ?: 0.0;
mysqli_stmt_close($stmt);

// -------------------------------------------------
// 4. STOCK HOLDINGS VALUE (from stock_transactions table)
// -------------------------------------------------
$stock_value = 0.0;
$stmt = mysqli_prepare($link, "
    SELECT SUM(st.shares * st.price_per_share) AS current_value
    FROM stock_transactions st
    WHERE st.user_id = ?
      AND st.type = 'buy'
      AND st.status = 'active'
");
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $stock_value);
mysqli_stmt_fetch($stmt);
$stock_value = (float)$stock_value ?: 0.0;
mysqli_stmt_close($stmt);

// -------------------------------------------------
// 5. TOTAL PORTFOLIO VALUE
// -------------------------------------------------
$portfolio_value = $balance + $investment_value + $stock_value;

// -------------------------------------------------
// 6. RECENT ORDERS (last 3 Tesla purchases)
// -------------------------------------------------
$recent_orders = [];
$stmt = mysqli_prepare($link, "
    SELECT o.id, o.amount, o.status, o.payment_method, o.order_date, o.created_at,
           c.title, c.year, c.image_url
    FROM orders o
    LEFT JOIN cars c ON o.car_id = c.id
    WHERE o.user_id = ?
    ORDER BY o.order_date DESC, o.created_at DESC
    LIMIT 3
");
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
while ($row = mysqli_fetch_assoc($result)) {
    $recent_orders[] = $row;
}
mysqli_stmt_close($stmt);

// -------------------------------------------------
// 7. MOCK STOCK DATA (you can replace with real API later)
// -------------------------------------------------
$stock_symbols = ['NVDA' => 'NVIDIA', 'AAPL' => 'Apple', 'TSLA' => 'Tesla', 'AMZN' => 'Amazon', 'GOOGL' => 'Alphabet'];
$stock_prices = [
    'NVDA' => 495.22,
    'AAPL' => 189.84,
    'TSLA' => 238.25,
    'AMZN' => 178.50,
    'GOOGL' => 152.13
];
?>
<!-- ============================================= -->
<!-- DASHBOARD PAGE -->
<!-- ============================================= -->
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <!-- Top Bar -->
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()" class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">Dashboard</div>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-7xl mx-auto">
            <!-- Welcome + Wallet -->
            <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
                <div class="absolute inset-0 opacity-10">
                    <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                    <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
                </div>
                <div class="relative z-10">
                    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                        <div class="mb-4 lg:mb-0 lg:flex-1">
                            <h1 class="text-xl font-light mb-1">Welcome back, <?= htmlspecialchars($fullname ?? 'User') ?></h1>
                            <p class="text-gray-300 text-sm">Track your investments, manage your portfolio, and explore opportunities.</p>
                        </div>
                        <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                            <div class="flex items-center justify-between mb-3">
                                <div>
                                    <p class="text-xs text-gray-300 mb-1">Available Balance</p>
                                    <p class="text-xl font-light">$<?= number_format($balance, 2) ?></p>
                                </div>
                                <div class="w-10 h-10 bg-white bg-opacity-20 rounded-lg flex items-center justify-center">
                                    <i data-lucide="wallet" class="w-5 h-5"></i>
                                </div>
                            </div>
                            <div class="flex space-x-2">
                                <a href="deposit.php" class="flex-1 bg-white bg-opacity-20 hover:bg-opacity-30 text-white text-xs font-medium py-1.5 px-3 rounded-md transition-all duration-200">
                                    <i data-lucide="plus" class="w-3 h-3 inline mr-1"></i> Deposit
                                </a>
                                <a href="withdraw.php" class="flex-1 bg-white bg-opacity-20 hover:bg-opacity-30 text-white text-xs font-medium py-1.5 px-3 rounded-md transition-all duration-200">
                                    <i data-lucide="minus" class="w-3 h-3 inline mr-1"></i> Withdraw
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-xs font-medium text-gray-500 mb-1">Portfolio Value</p>
                            <p class="text-lg font-light text-black mb-1">$<?= number_format($portfolio_value, 0) ?></p>
                            <p class="text-xs text-green-600">All assets combined</p>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="trending-up" class="w-5 h-5 text-green-500"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-xs font-medium text-gray-500 mb-1">Investments</p>
                            <p class="text-lg font-light text-black mb-1">$<?= number_format($investment_value, 0) ?></p>
                            <p class="text-xs text-blue-600">Current market value</p>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="pie-chart" class="w-5 h-5 text-blue-500"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-xs font-medium text-gray-500 mb-1">Stock Holdings</p>
                            <p class="text-lg font-light text-black mb-1">$<?= number_format($stock_value, 0) ?></p>
                            <p class="text-xs text-purple-600">Current value</p>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="bar-chart-3" class="w-5 h-5 text-purple-500"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-xs font-medium text-gray-500 mb-1">Tesla Vehicles</p>
                            <p class="text-lg font-medium text-black mb-1"><?= $tesla_count ?></p>
                            <p class="text-xs text-red-600">In your garage</p>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="car" class="w-5 h-5 text-red-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Orders -->
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100 mb-6">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-lg font-light text-black mb-1">Recent Orders</h3>
                        <p class="text-xs text-gray-500">Your latest Tesla purchases</p>
                    </div>
                    <a href="history.php" class="text-xs text-black hover:text-gray-600 font-medium">
                        View All <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                    </a>
                </div>
                <div class="space-y-3">
                    <?php if (empty($recent_orders)): ?>
                        <p class="text-center text-gray-500 py-6">No orders yet. Time to get your Tesla!</p>
                    <?php else: ?>
                        <?php foreach ($recent_orders as $o): ?>
                            <?php
                            $dt = new DateTime($o['order_date'] ?: $o['created_at']);
                            $dt->setTimezone(new DateTimeZone('Africa/Lagos'));
                            ?>
                            <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors duration-200">
                                <div class="w-12 h-12 bg-gray-200 rounded-lg overflow-hidden flex-shrink-0">
                                    <?php if (!empty($o['image_url'])): ?>
                                        <img src="<?= htmlspecialchars($o['image_url']) ?>" alt="Car" class="w-full h-full object-cover">
                                    <?php else: ?>
                                        <div class="w-full h-full flex items-center justify-center bg-gray-300">
                                            <i data-lucide="car" class="w-6 h-6 text-gray-600"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="flex-1">
                                    <h4 class="font-medium text-black text-sm"><?= htmlspecialchars($o['title'] ?? 'Tesla Vehicle') ?> (<?= $o['year'] ?? 'N/A' ?>)</h4>
                                    <p class="text-xs text-gray-500"><?= $dt->format('M j, Y') ?></p>
                                </div>
                                <div class="text-right">
                                    <p class="font-medium text-black text-sm">$<?= number_format((float)$o['amount'], 0) ?></p>
                                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium <?= strtolower($o['status']) === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' ?>">
                                        <?= ucfirst($o['status'] ?? 'pending') ?>
                                    </span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Market Overview (Mock Data) -->
            <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-lg font-light text-black mb-1">Market Overview</h3>
                        <p class="text-xs text-gray-500">Top stocks performance</p>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <?php foreach ($stock_symbols as $sym => $name): ?>
                        <?php $price = $stock_prices[$sym] ?? 0; $change = rand(-10, 15); $is_up = $change >= 0; ?>
                        <div class="flex items-center justify-between p-4 bg-gradient-to-r from-<?= $is_up ? 'green' : 'red' ?>-50 to-transparent rounded-lg border border-<?= $is_up ? 'green' : 'red' ?>-200">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-white rounded-lg shadow flex items-center justify-center">
                                    <span class="font-bold text-sm"><?= $sym ?></span>
                                </div>
                                <div>
                                    <p class="font-medium text-black text-sm"><?= $name ?></p>
                                    <p class="text-xs text-gray-600">$<?= number_format($price, 2) ?></p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="font-medium <?= $is_up ? 'text-green-600' : 'text-red-600' ?> text-sm">
                                    <?= $is_up ? '+' : '' ?><?= $change ?>%
                                </p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </main>
</div>

<?php include 'footer.php'; ?>