<?php
include 'header.php';
$deposit_details = $_SESSION['deposit_details'] ?? null;
if (!$deposit_details) {
    echo "<script>window.location.href = 'deposit.php';</script>";
    exit;
}
$msg = $err_tx = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $transaction_id = trim($_POST['transaction_id'] ?? '');
    if (empty($transaction_id)) {
        $err_tx = 'Transaction ID is required';
    } elseif (strlen($transaction_id) < 10) {
        $err_tx = 'Invalid transaction ID';
    } else {
       
        $amount = $deposit_details['receiving_amount'];
        $method = $deposit_details['method']; // BTC, ETH, LTC
        $status = 'pending'; // initial status
        $type = "deposit";
        $created_at = date('Y-m-d H:i:s');
        // Use prepared statement to insert into `deposits` table
        $sql = "INSERT INTO transactions
                    (user_id, amount, type, crypto_method, transaction_hash, status, created_at)
                VALUES
                    (?, ?, ?, ?, ?, ?,?)";
       
        $stmt = mysqli_prepare($link, $sql);
        if ($stmt) {
            mysqli_stmt_bind_param(
                $stmt,
                "idsssss",
                $user_id,
                $amount,
                $type,
                $method,
                $transaction_id,
                $status,
                $created_at
            );
            if (mysqli_stmt_execute($stmt)) {
                $msg = 'Deposit submitted successfully! Awaiting verification.';
               
                // Optional: Clear session details after submission
                unset($_SESSION['deposit_details']);
               
                // === DEPOSIT CONFIRMATION EMAIL ===
                $subject = "Deposit Received – $sitename";

                $body = "
                <div style='background: #000; padding: 20px; font-family: Arial, sans-serif;'>
                    <div style='max-width: 600px; margin: 0 auto; background: #0a0a0a; border-radius: 12px; overflow: hidden; border: 1px solid #1f1f1f;'>
                        
                        <!-- Header with Logo -->
                        <div style='background: #000; padding: 30px 20px; text-align: center;'>
                            <img src='$site_url/images/logo-white.png' width='120'>
                        </div>

                        <!-- Main Content -->
                        <div style='padding: 40px 32px; text-align: center; color: #ffffff;'>
                            <h1 style='font-size: 42px; font-weight: bold; color: #ffffff; margin: 0 0 16px 0; line-height: 1.1;'>
                                Deposit Received!
                            </h1>
                            <p style='font-size: 19px; color: #e2e8f0; margin: 20px 0 40px 0; line-height: 1.6;'>
                                Hi <strong>$fullname</strong>,<br>
                                We have received your $method deposit of <strong>$amount</strong>.
                            </p>

                            <p style='font-size: 18px; color: #cbd5e1; margin-bottom: 40px;'>
                                Transaction ID: <strong>$transaction_id</strong><br>
                                Your deposit is now pending verification. This usually takes just a few minutes.
                            </p>

                            <!-- View Portfolio Button -->
                            <a href='$site_url/portfolio.php' style='background: #ffffff; color: #000000; font-weight: bold; font-size: 18px; padding: 16px 40px; border-radius: 8px; text-decoration: none; display: inline-block; margin: 20px 0;'>
                                View My Portfolio
                            </a>

                            <p style='color: #64748b; font-size: 14px; margin-top: 50px;'>
                                You’ll receive another email as soon as your funds are credited.<br>
                                Thank you for choosing $sitename!
                            </p>
                        </div>

                        <!-- Footer -->
                        <div style='background: #111; padding: 30px; text-align: center; color: #64748b; font-size: 13px; border-top: 1px solid #1f1f1f;'>
                            <p style='margin: 0;'>
                                © 2025 $sitename. All rights reserved.<br>
                                <span style='color: #475569;'>Support Team • $sitename</span>
                            </p>
                        </div>
                    </div>
                </div>";

                $send = sendMail($email, $subject, $body);
                // ==============================================

            } else {
                $msg = 'Database error: ' . mysqli_error($link);
            }
            mysqli_stmt_close($stmt);
        } else {
            $msg = 'Failed to prepare statement.';
        }
    }
}
?>

<!-- =================================== HTML UI =================================== -->
<div class="flex-1 flex flex-col overflow-hidden lg:ml-72">
    <!-- Top Bar -->
    <header class="bg-white border-b border-gray-200">
        <div class="flex items-center justify-between px-6 py-3">
            <div class="flex items-center">
                <button onclick="toggleSidebar()"
                    class="lg:hidden text-gray-500 hover:text-gray-700 p-1.5 rounded-md hover:bg-gray-100 mr-3">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <div class="font-light text-lg text-black">Confirm Crypto Deposit</div>
            </div>
            
        </div>
    </header>

    <!-- Info Alert -->
    <div class="bg-blue-50 border-l-4 border-blue-500 text-blue-700 px-4 py-3 mx-6 mt-3 rounded-r-md" role="alert">
        <div class="flex items-center">
            <i data-lucide="info" class="w-4 h-4 mr-2 flex-shrink-0"></i>
            <span class="text-sm">Please complete your crypto transfer and submit the transaction ID.</span>
            <button onclick="this.parentElement.parentElement.style.display='none'"
                class="ml-auto text-blue-500 hover:text-blue-700">
                <i data-lucide="x" class="w-3 h-3"></i>
            </button>
        </div>
    </div>

   <?php if ($msg): ?>
    <div class="mx-6 mt-4 p-4 rounded-lg text-sm <?php echo strpos($msg, 'success') !== false ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
        <?php echo htmlspecialchars($msg); ?>
    </div>

    <script>
        setTimeout(function() {
            window.location.href = "deposit.php"; // change to your redirect page
        }, 5000);
    </script>
<?php endif; ?>


    <!-- Main Content -->
    <main class="flex-1 overflow-y-auto p-6 bg-white pb-20 lg:pb-6">
        <div class="max-w-2xl mx-auto">
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <h2 class="text-lg font-semibold mb-4">Deposit Details</h2>
                <div class="grid grid-cols-1 gap-4 mb-6">
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Amount</span>
                        <span class="text-sm font-medium">$<?php echo number_format($deposit_details['receiving_amount'], 2); ?></span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Payment Method</span>
                        <span class="text-sm font-medium flex items-center space-x-2">
                            <?php if ($deposit_details['method'] === 'BTC'): ?>
                                <img src="image/ORlsQwv0PZBkspRvbK9uU5RRxhcyGuj2yC1MtOrQ.png" alt="Bitcoin" class="w-6 h-6 rounded" />
                                <span>Bitcoin (BTC)</span>
                            <?php elseif ($deposit_details['method'] === 'ETH'): ?>
                                <img src="image/D8Kmhhgnkh2f4M8kCLnMRnacE2G3Tq0oX97LkhsG.png" alt="Ethereum" class="w-6 h-6 rounded" />
                                <span>Ethereum (ETH)</span>
                            <?php elseif ($deposit_details['method'] === 'LTC'): ?>
                                <img src="image/yfA6ZHo9c2RBYPipI94Mw2jRNfR6qOyhtreYRlo2.png" alt="Litecoin" class="w-6 h-6 rounded" />
                                <span>Litecoin (LTC)</span>
                            <?php endif; ?>
                        </span>
                    </div>
                </div>

                <!-- Wallet Address -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Wallet Address</label>
                    <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg border border-gray-200 flex-wrap gap-3">
                        <code class="text-xs break-all"><?php echo htmlspecialchars($crypto_addresses[$deposit_details['method']] ?? 'N/A'); ?></code>
                        <button type="button"
                            class="text-xs px-3 py-1.5 bg-black text-white rounded hover:bg-gray-800 copy-address"
                            data-address="<?php echo htmlspecialchars($crypto_addresses[$deposit_details['method']] ?? ''); ?>">
                            Copy
                        </button>
                    </div>
                </div>

                <!-- QR Code -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Scan QR Code</label>
                    <div class="flex justify-center">
                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=220x220&data=<?php echo urlencode($crypto_addresses[$deposit_details['method']] ?? ''); ?>"
                             alt="QR Code"
                             class="w-48 h-48 object-contain border-2 border-gray-200 rounded-lg p-2 bg-white shadow">
                    </div>
                </div>

                <!-- Submit Form -->
                <form action="" method="POST" class="space-y-5">
                    <div>
                        <label for="transaction_id" class="block text-sm font-medium text-gray-700 mb-2">
                            Transaction ID / Hash
                        </label>
                        <input id="transaction_id"
                               name="transaction_id"
                               type="text"
                               placeholder="e.g. 0x123abc... or bc1q..."
                               class="w-full px-4 py-3 border <?php echo $err_tx ? 'border-red-500' : 'border-gray-300'; ?> rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition"
                               required />
                        <?php if ($err_tx): ?>
                            <p class="text-xs text-red-600 mt-1"><?php echo htmlspecialchars($err_tx); ?></p>
                        <?php endif; ?>
                    </div> <br> <br>

                    <div class="pt-3">
                        <button type="submit"
                                class="w-full bg-black text-white py-3.5 px-6 rounded-lg font-medium hover:bg-gray-800 transition-colors duration-200 flex items-center justify-center space-x-2">
                            <i data-lucide="send" class="w-5 h-5"></i>
                            <span>Submit for Verification</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Copy to Clipboard Script -->
        <script>
            document.querySelectorAll('.copy-address').forEach(btn => {
                btn.addEventListener('click', async () => {
                    const address = btn.dataset.address;
                    if (!address) return;
                    try {
                        await navigator.clipboard.writeText(address);
                        const original = btn.textContent;
                        btn.textContent = 'Copied!';
                        btn.classList.add('bg-green-600');
                        setTimeout(() => {
                            btn.textContent = original;
                            btn.classList.remove('bg-green-600');
                        }, 2000);
                    } catch (err) {
                        alert('Failed to copy');
                    }
                });
            });
        </script>
    </main>
</div>

<?php include 'footer.php'; ?>