<?php
include 'session.php';
// === FILTERS & SORTING ===
$where = [];
$params = [];
$types = '';

// Available only
if (!empty($_GET['available'])) {
    $where[] = "status = 'available'";
}

// Featured
if (!empty($_GET['featured'])) {
    $where[] = "featured = 1";
}

// Make
if (!empty($_GET['make'])) {
    $where[] = "model LIKE ?";
    $params[] = '%' . $_GET['make'] . '%';
    $types .= 's';
}

// Model
if (!empty($_GET['model'])) {
    $where[] = "model = ?";
    $params[] = $_GET['model'];
    $types .= 's';
}

// Year
if (!empty($_GET['year'])) {
    $where[] = "year = ?";
    $params[] = $_GET['year'];
    $types .= 'i';
}

// Price Range
if (!empty($_GET['price_range'])) {
    $range = explode('-', $_GET['price_range']);
    if (count($range) == 2) {
        if ($range[1] === '+') {
            $where[] = "price >= ?";
            $params[] = $range[0];
            $types .= 'd';
        } else {
            $where[] = "price BETWEEN ? AND ?";
            $params[] = $range[0];
            $params[] = $range[1];
            $types .= 'dd';
        }
    }
}

$where_clause = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// === SORTING ===
$sort = 'created_at DESC';
if (!empty($_GET['sort'])) {
    switch ($_GET['sort']) {
        case 'oldest': $sort = 'created_at ASC'; break;
        case 'price_low': $sort = 'price ASC'; break;
        case 'price_high': $sort = 'price DESC'; break;
        case 'newest': $sort = 'created_at DESC'; break;
    }
}

// === PAGINATION ===
$per_page = 9;
$page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($page - 1) * $per_page;

// Count total
$count_sql = "SELECT COUNT(*) as total FROM cars $where_clause";
$count_stmt = $link->prepare($count_sql);
if ($types) $count_stmt->bind_param($types, ...$params);
$count_stmt->execute();
$total_cars = $count_stmt->get_result()->fetch_assoc()['total'];
$total_pages = ceil($total_cars / $per_page);

// Fetch cars
$sql = "SELECT * FROM cars $where_clause ORDER BY $sort LIMIT ? OFFSET ?";
$stmt = $link->prepare($sql);
$bind_types = $types . 'ii';
$params[] = $per_page;
$params[] = $offset;
$stmt->bind_param($bind_types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tesla Investment - Inventory</title>
    <link rel="icon" href="https://tesla.cycloverseworld.info/storage/settings/nD0jqatt0igD7oF7VC4CdsckD2tbSAV47lXUHebb.png">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>
    <link rel="stylesheet" href="css/app-BrT5j27K.css" />
    <script type="module" src="js/app-8wzWMZTN.js"></script>
</head>
<body class="font-sans antialiased bg-white text-black">


<main>
<div class="min-h-screen bg-white">

    <!-- Hero Header -->
    <header class="relative overflow-hidden bg-gradient-to-br from-black via-gray-900 to-black text-white">
        <svg class="absolute inset-0 opacity-[0.06] z-0 pointer-events-none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
            <defs><pattern id="grid" width="40" height="40" patternUnits="userSpaceOnUse">
                <path d="M 40 0 L 0 0 0 40" fill="none" stroke="white" stroke-width="1" />
            </pattern></defs>
            <rect width="100%" height="100%" fill="url(#grid)" />
        </svg>
        <div class="absolute inset-0 z-0 pointer-events-none">
            <img src="https://tesla.cycloverseworld.info/images/tesla-model-y.jpg" alt="" class="h-full w-full object-cover opacity-20">
            <div class="absolute inset-0 bg-gradient-to-b from-black/80 via-black/70 to-black/90"></div>
        </div>
        <div class="relative z-10">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-14 lg:py-20 text-center">
                <h1 class="text-4xl font-semibold tracking-tight sm:text-5xl">Browse Inventory</h1>
                <p class="mt-4 max-w-3xl mx-auto text-base text-gray-300 sm:text-lg">
                    Explore premium electric vehicles ready for immediate delivery.
                </p>
            </div>
        </div>
        <!-- Wave -->
        <div class="absolute bottom-0 left-0 right-0 translate-y-[1px]">
            <svg viewBox="0 0 1440 80" xmlns="http://www.w3.org/2000/svg">
                <path fill="#ffffff" d="M0,64L48,69.3C96,75,192,85,288,85.3C384,85,480,75,576,53.3C672,32,768,0,864,0C960,0,1056,32,1152,53.3C1248,75,1344,85,1392,90.7L1440,96L1440,160L0,160Z"></path>
            </svg>
        </div>
    </header>

    <!-- Filter + Results -->
    <section class="py-12 lg:py-16">
        <div class="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col lg:flex-row gap-8">

                <!-- Filter Sidebar -->
                <div class="lg:w-1/4">
                    <div id="filter-sidebar" class="bg-white border border-gray-200 rounded-2xl p-6 shadow lg:sticky lg:top-24 hidden lg:block">
                        <div class="flex items-center justify-between mb-6">
                            <h2 class="text-xl font-medium text-black">Filters</h2>
                            <button id="close-mobile-filters" class="lg:hidden p-2 text-tesla-500 hover:text-tesla-700">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>
                        <form action="" method="GET" class="space-y-6" id="filter-form">
                            <!-- Quick Filters -->
                            <div>
                                <h3 class="text-sm font-medium text-gray-700 mb-3">Quick Filters</h3>
                                <div class="space-y-2">
                                    <label class="flex items-center group cursor-pointer">
                                        <input type="checkbox" name="available" value="true" <?= !empty($_GET['available']) ? 'checked' : '' ?> class="w-4 h-4 text-black border-gray-300 rounded focus:ring-black">
                                        <span class="ml-3 text-sm text-gray-600 group-hover:text-black">Available Only</span>
                                    </label>
                                    <label class="flex items-center group cursor-pointer">
                                        <input type="checkbox" name="featured" value="true" <?= !empty($_GET['featured']) ? 'checked' : '' ?> class="w-4 h-4 text-black border-gray-300 rounded focus:ring-black">
                                        <span class="ml-3 text-sm text-gray-600 group-hover:text-black">Featured Vehicles</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Make -->
                            <div>
                                <h3 class="text-sm font-medium text-gray-700 mb-3">Make</h3>
                                <select name="make" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                    <option value="">All Makes</option>
                                    <option value="Tesla" <?= ($_GET['make'] ?? '') === 'Tesla' ? 'selected' : '' ?>>Tesla</option>
                                </select>
                            </div>

                            <!-- Model -->
                            <div>
                                <h3 class="text-sm font-medium text-gray-700 mb-3">Model</h3>
                                <select name="model" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                    <option value="">All Models</option>
                                    <option value="Model 3" <?= ($_GET['model'] ?? '') === 'Model 3' ? 'selected' : '' ?>>Model 3</option>
                                    <option value="Model X" <?= ($_GET['model'] ?? '') === 'Model X' ? 'selected' : '' ?>>Model X</option>
                                </select>
                            </div>

                            <!-- Year -->
                            <div>
                                <h3 class="text-sm font-medium text-gray-700 mb-3">Year</h3>
                                <select name="year" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                    <option value="">All Years</option>
                                    <option value="2024" <?= ($_GET['year'] ?? '') == 2024 ? 'selected' : '' ?>>2024</option>
                                    <option value="2021" <?= ($_GET['year'] ?? '') == 2021 ? 'selected' : '' ?>>2021</option>
                                </select>
                            </div>

                            <!-- Price Range -->
                            <div>
                                <h3 class="text-sm font-medium text-gray-700 mb-3">Price Range</h3>
                                <select name="price_range" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                    <option value="">All Prices</option>
                                    <option value="0-50000" <?= ($_GET['price_range'] ?? '') === '0-50000' ? 'selected' : '' ?>>Under $50,000</option>
                                    <option value="50000-75000" <?= ($_GET['price_range'] ?? '') === '50000-75000' ? 'selected' : '' ?>>$50k–$75k</option>
                                    <option value="75000-100000" <?= ($_GET['price_range'] ?? '') === '75000-100000' ? 'selected' : '' ?>>$75k–$100k</option>
                                    <option value="100000-150000" <?= ($_GET['price_range'] ?? '') === '100000-150000' ? 'selected' : '' ?>>$100k–$150k</option>
                                    <option value="150000+" <?= ($_GET['price_range'] ?? '') === '150000+' ? 'selected' : '' ?>>$150,000+</option>
                                </select>
                            </div>

                            <!-- Sort -->
                            <div>
                                <h3 class="text-sm font-medium text-gray-700 mb-3">Sort By</h3>
                                <select name="sort" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                    <option value="newest" <?= ($_GET['sort'] ?? 'newest') === 'newest' ? 'selected' : '' ?>>Newest First</option>
                                    <option value="oldest" <?= ($_GET['sort'] ?? '') === 'oldest' ? 'selected' : '' ?>>Oldest First</option>
                                    <option value="price_low" <?= ($_GET['sort'] ?? '') === 'price_low' ? 'selected' : '' ?>>Price: Low to High</option>
                                    <option value="price_high" <?= ($_GET['sort'] ?? '') === 'price_high' ? 'selected' : '' ?>>Price: High to Low</option>
                                </select>
                            </div>

                            <div class="flex flex-col space-y-3 pt-6 border-t border-tesla-200">
                                <button type="submit" class="w-full bg-black hover:bg-gray-800 text-white py-3 px-4 rounded-lg font-medium">
                                    Apply Filters
                                </button>
                                <a href="?" class="w-full border border-gray-300 text-gray-700 hover:bg-gray-50 py-3 px-4 rounded-lg font-medium text-center">
                                    Reset All
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Results -->
                <div class="lg:w-3/4">
                    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8">
                        <div>
                            <h2 class="text-2xl font-medium text-tesla-900 mb-2">Available Vehicles</h2>
                            <p class="text-tesla-600">
                                Showing <?= $offset + 1 ?> - <?= min($offset + $per_page, $total_cars) ?> of <?= $total_cars ?> vehicles
                            </p>
                        </div>
                        <div class="flex items-center space-x-2 mt-4 sm:mt-0">
                            <span class="text-sm text-tesla-600">View:</span>
                            <button id="grid-view" class="p-2 text-tesla-500 hover:text-tesla-900 hover:bg-tesla-100 rounded-lg view-toggle active">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"/></svg>
                            </button>
                            <button id="list-view" class="p-2 text-tesla-500 hover:text-tesla-900 hover:bg-tesla-100 rounded-lg view-toggle">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 10h16M4 14h16M4 18h16"/></svg>
                            </button>
                        </div>
                    </div>

                    <!-- DYNAMIC CARDS -->
                    <div id="cars-container" class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6 lg:gap-8">
                        <?php while ($car = $result->fetch_assoc()): ?>
                            <article class="group rounded-xl border border-gray-200 bg-white shadow-sm transition hover:shadow-md">
                                <a href="car_details.php?id=<?= $car['id'] ?>" class="block overflow-hidden rounded-t-xl">
                                    <div class="relative aspect-[16/9]">
                                        <img src="<?= htmlspecialchars($car['image_url']) ?>" alt="<?= htmlspecialchars($car['title']) ?>"
                                             class="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105"
                                             loading="lazy">
                                        <?php if ($car['status'] === 'sold_out'): ?>
                                            <div class="absolute right-3 top-3 rounded-full bg-red-600 px-2.5 py-1 text-[11px] font-medium text-white">
                                                Sold Out
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </a>
                                <div class="p-4">
                                    <h3 class="mb-1 text-base font-medium text-black group-hover:text-black/80 sm:text-lg">
                                        <a href="car_details.php?id=<?= $car['id'] ?>">
                                            <?= htmlspecialchars($car['title']) ?>
                                        </a>
                                    </h3>
                                    <p class="text-sm text-gray-600"><?= $car['year'] ?> <?= htmlspecialchars($car['model']) ?></p>
                                    <div class="mt-3 mb-3 flex items-center gap-6 text-xs text-gray-600">
                                        <div><span class="font-medium"><?= $car['range_miles'] ?>mi</span><span class="block text-[10px]">Range</span></div>
                                        <div><span class="font-medium"><?= $car['accel_0_60'] ?>s</span><span class="block text-[10px]">0-60 mph</span></div>
                                        <div><span class="font-medium"><?= $car['top_speed'] ?>mph</span><span class="block text-[10px]">Top Speed</span></div>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <div>
                                            <p class="text-sm font-medium text-black">Starting at $<?= number_format($car['price'], 2) ?>*</p>
                                            <p class="text-xs text-gray-500">After Est. Gas Savings</p>
                                        </div>
                                        <div class="flex items-center gap-2">
                                            <a href="car_details.php?id=<?= $car['id'] ?>"
                                               class="rounded border border-gray-300 px-3 py-1.5 text-xs font-medium text-black hover:bg-gray-50">Learn</a>
                                            <?php if ($car['status'] === 'available'): ?>
                                                <a href="car_details.php?id=<?= $car['id'] ?>"
                                                   class="rounded bg-black px-3 py-1.5 text-xs font-medium text-white hover:bg-gray-800">Order</a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        <?php endwhile; ?>
                    </div>

                    <!-- Pagination -->
                    <?php if ($total_pages > 1): ?>
                    <div class="mt-12 flex justify-center">
                        <nav class="bg-white border border-tesla-200 rounded-lg p-2 inline-flex space-x-1">
                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                <a href="?page=<?= $i ?>&<?= http_build_query($_GET) ?>"
                                   class="px-3 py-2 text-sm font-medium rounded <?= $i === $page ? 'bg-black text-white' : 'text-gray-700 hover:bg-gray-100' ?>">
                                    <?= $i ?>
                                </a>
                            <?php endfor; ?>
                        </nav>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</div>
</main>

<script>
    // Your existing JS (filter toggle, view switch, auto-submit, etc.)
    document.addEventListener('DOMContentLoaded', function () {
        const mobileFilterToggle = document.getElementById('mobile-filter-toggle');
        const filterSidebar = document.getElementById('filter-sidebar');
        const closeMobileFilters = document.getElementById('close-mobile-filters');

        if (mobileFilterToggle) {
            mobileFilterToggle.addEventListener('click', () => {
                filterSidebar.classList.toggle('hidden');
                mobileFilterToggle.querySelector('svg:last-child').classList.toggle('rotate-180');
            });
        }
        if (closeMobileFilters) {
            closeMobileFilters.addEventListener('click', () => {
                filterSidebar.classList.add('hidden');
            });
        }

        // Auto-submit on change
        document.querySelectorAll('#filter-form select, #filter-form input').forEach(el => {
            el.addEventListener('change', () => {
                clearTimeout(window.filterTimeout);
                window.filterTimeout = setTimeout(() => document.getElementById('filter-form').submit(), 300);
            });
        });
    });
</script>

<?php
$stmt->close();
$count_stmt->close();
$link->close();
include 'footer.php';
?>