<?php 
session_start();
include 'header.php'; 
$msg = "";
$err = "";

if(isset($_POST['delete'])){
    $uid = trim($_POST['userId']);
    
    mysqli_query($link, "DELETE FROM users WHERE id = '$uid' ");
    echo '<script>alert("User Account was deleted successfully");window.location.href = "users.php" </script>';
}

if (isset($_POST['user_login'])) {
    $email = text_input($_POST['email']);
    $userid = text_input($_POST['userId']);
    $password = text_input($_POST['password']);

    $stmt = $link->prepare("SELECT * FROM users WHERE email = ? AND password = ?");
    $stmt->bind_param("ss", $email, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $rows = $result->fetch_assoc();
        $user_email = $rows['email'];
        $uuid = $rows['id'];
        $user_password = $rows['password']; 
        $username = $rows['username'];
        $_SESSION['USER_LOG'] = $user_email;

        echo "<script>
            alert('Login successful');
            setTimeout(function () {
                window.open('../user/dashboard.php', '_blank');
            }, 1000); // Delay of 1 second (1000ms)
        </script>";
    } else {
        $err = 'User not found';    
    }
    $stmt->close();
}

if(isset($_POST['fund_user'])) {
    $email = mysqli_real_escape_string($link, $_POST['email']);
    $currency = mysqli_real_escape_string($link, $_POST['currency']);
    $amount = floatval($_POST['amount']);
   
    
    if($amount > 0) {
        // Fetch user's current balance
        $sql = "SELECT * FROM users WHERE email = '$email'";
        $result = mysqli_query($link, $sql);
        $user = mysqli_fetch_assoc($result);
        
        // Determine which balance to update
        $balance_field = '';
        switch($currency) {
            case 'USDT': $balance_field = 'usdt_bal'; break;
            case 'BTC': $balance_field = 'btc_bal'; break;
            case 'ETH': $balance_field = 'eth_bal'; break;
            case 'LTC': $balance_field = 'ltc_bal'; break;
            case 'MATIC': $balance_field = 'matic_bal'; break;
            case 'SOL': $balance_field = 'sol_bal'; break;
            case 'XLM': $balance_field = 'xlm_bal'; break;
            case 'profit': $balance_field = 'profit'; break;
            default: $balance_field = 'balance';
        }
        
        // Update balance
        $new_balance = floatval($user[$balance_field]) + $amount;
        $update_sql = "UPDATE users SET $balance_field = '$new_balance' WHERE email = '$email'";
        
        if(mysqli_query($link, $update_sql)) {
            
         $success_msg = "Successfully funded $amount";
         echo '<script>alert("'.$success_msg.'"); window.location.href = "users.php";</script>';

        } else {
            $err = "Error updating balance: " . mysqli_error($link);
            echo '<script>alert("'.$err.'");</script>';
        }
    } else {
        $err = "Amount must be greater than 0";
        echo '<script>alert("'.$err.'");</script>';
    }
}
?>

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.css">
<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.jqueryui.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.5.6/css/buttons.jqueryui.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.5.6/css/buttons.bootstrap.min.css">

<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.19/js/dataTables.jqueryui.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/1.5.6/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.jqueryui.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.print.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.colVis.min.js"></script>

<style>
    .table-responsive {
        overflow-x: hidden;
    }

    @media (max-width: 8000px) {
        .table-responsive {
            overflow-x: auto;
        }
    }
</style>

<?php 
if ($msg != "") {
    echo "<div style='padding:20px;background-color:#dce8f7;color:black'> $msg</div class='btn btn-success'>" ."</br></br>"; 
}
if ($err != "") {
    echo customAlert("error", $err);
}
?>
<div class="page-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">All Users</h4>
                    </div><!-- end card header -->

                    <div class="card-body">
                        <div id="customerList">
                            <div class="table-responsive table-card mt-3 mb-1">
                                <table id="myTable" class="table-responsive">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Full Name</th>
                                            <th>Email</th>
                                            <th>Date</th>
                                            <th>ACTION</th>
                                            <th>ACTION</th>
                                            <th>ACTION</th>
                                            <th>ACTION</th>
                                            <th>ACTION</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $sql = "SELECT * FROM users ORDER BY id DESC";
                                        $result = mysqli_query($link,$sql);
                                        if(mysqli_num_rows($result) > 0){
                                            while($row = mysqli_fetch_assoc($result)){  
                                        ?>
                                        <tr>
                                            <form method="post">
                                                <input type="hidden" name="userId" value="<?php echo $row['id'];?>">
                                                <input type="hidden" name="email" value="<?php echo $row['email'] ?>">
                                                <input type="hidden" name="password" value="<?php echo $row['password'] ?>">

                                                <td><?php echo $row['fullname'];?></td>
                                                <td id="email"><?php echo $row['email'];?></td>
                                                <td><?php echo $row['created_at'];?></td>
                                                <td> 
                                                    <a href="user-edit.php?email=<?php echo $row['email']?>">
                                                        <button type="button" name="edit" style="width:100%" class="btn btn-primary">
                                                            <span class="fa fa-check">-Edit</span>
                                                        </button>
                                                    </a>
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-primary fund-btn" 
                                                            data-email="<?php echo htmlspecialchars($row['email']); ?>"
                                                            data-balances='<?php echo json_encode([
                                                               
                                                                'btc_bal' => $row['btc_bal'],
                                                              
                                                                'profit' => $row['profit'],
                                                                'balance' => $row['balance']
                                                            ]); ?>'>
                                                        <i class="fas fa-coins"></i> Fund
                                                    </button>
                                                </td>
                                                <td> 
                                                    <a href="mailuser.php?email=<?php echo $row['email']?>">
                                                        <button type="button" name="sendmail" style="width:100%" class="btn btn-primary">
                                                            <span class="fa fa-check">-Send Mail</span>
                                                        </button>
                                                    </a>
                                                </td>
                                                <td>
                                                    <button class="btn btn-sm btn-success" name="user_login" type="submit">Login Account</button>
                                                </td>
                                                <td>
                                                    <button type="submit" onclick="return confirm('Do you want to delete this account')" name="delete" style="width:100%" class="btn btn-danger">
                                                        <span class="fas fa-trash">-Delete</span>
                                                    </button>
                                                </td>
                                            </form>
                                        </tr>
                                        <?php 
                                            }
                                        } 
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div><!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end col -->
        </div>
    </div>
</div>


<!-- Fund User Modal -->
<div class="modal fade" id="fundModal" tabindex="-1" aria-labelledby="fundModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" id="fundForm">
                <div class="modal-header">
                    <h5 class="modal-title" id="fundModalLabel">Fund User Account</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="email" id="modalEmail">
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Current Balances</label>
                            <div class="card">
                                <div class="card-body p-2">
                                    <table class="table table-sm table-borderless mb-0" id="currentBalances">
                                        <!--<tr>-->
                                        <!--    <td>USDT:</td>-->
                                        <!--    <td class="text-end" id="usdt-bal">0.00</td>-->
                                        <!--</tr>-->
                                        <tr>
                                            <td>BTC: in USD</td>
                                            <td class="text-end" id="btc-bal">0.00</td>
                                        </tr>
                                        <!--<tr>-->
                                        <!--    <td>ETH:</td>-->
                                        <!--    <td class="text-end" id="eth-bal">0.00</td>-->
                                        <!--</tr>-->
                                        <!--<tr>-->
                                        <!--    <td>LTC:</td>-->
                                        <!--    <td class="text-end" id="ltc-bal">0.00</td>-->
                                        <!--</tr>-->
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">&nbsp;</label>
                            <div class="card">
                                <div class="card-body p-2">
                                    <table class="table table-sm table-borderless mb-0">
                                        <!--<tr>-->
                                        <!--    <td>MATIC:</td>-->
                                        <!--    <td class="text-end" id="matic-bal">0.00</td>-->
                                        <!--</tr>-->
                                        <!--<tr>-->
                                        <!--    <td>SOL:</td>-->
                                        <!--    <td class="text-end" id="sol-bal">0.00</td>-->
                                        <!--</tr>-->
                                        <!--<tr>-->
                                        <!--    <td>XLM:</td>-->
                                        <!--    <td class="text-end" id="xlm-bal">0.00</td>-->
                                        <!--</tr>-->
                                        <tr>
                                            <td>Profit:</td>
                                            <td class="text-end" id="profit-bal">0.00</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Currency</label>
                            <select class="form-select" name="currency" required>
                                <option value="balance" selected>Main Balance</option>
                                <option value="profit">Profit</option>
                                <option value="BTC">BTC</option>
                                <!--<option value="ETH">ETH</option>-->
                                <!--<option value="LTC">LTC</option>-->
                                <!--<option value="MATIC">MATIC</option>-->
                                <!--<option value="SOL">SOL</option>-->
                                <!--<option value="XLM">XLM</option>-->
                                <!--<option value="USDT" >USDT</option>-->
                                
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Amount</label>
                            <div class="input-group">
                                <input type="number" step="0.00000001" class="form-control" name="amount" required>
                                <span class="input-group-text currency-symbol">USDT</span>
                            </div>
                        </div>
                    </div>
                    
                  
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="fund_user" class="btn btn-primary">Fund Account</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#myTable').DataTable();
        
        // Handle fund button click
        $('.fund-btn').click(function() {
            var email = $(this).data('email');
            var balances = $(this).data('balances');
            
            // Set the email in the form
            $('#modalEmail').val(email);
            
            // Update the balance display
            $('#usdt-bal').text(balances.usdt_bal);
            $('#btc-bal').text(balances.btc_bal);
            $('#eth-bal').text(balances.eth_bal);
            $('#ltc-bal').text(balances.ltc_bal);
            $('#matic-bal').text(balances.matic_bal);
            $('#sol-bal').text(balances.sol_bal);
            $('#xlm-bal').text(balances.xlm_bal);
            $('#profit-bal').text(balances.profit);
            
            // Show the modal
            $('#fundModal').modal('show');
        });
        
        // Update currency symbol when currency changes
        $('select[name="currency"]').change(function() {
            $('.currency-symbol').text($(this).val());
        });
    });
</script>

<?php include 'footer.php'; ?>