<?php
include 'header.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$msg = $err = "";

/* ---------- SAVE (UPDATE ORDER) ---------- */
if (isset($_POST['save_order'])) {
    $id = (int)$_POST['id'];
    $amount = (float)$_POST['amount'];
    $status = $_POST['status'];
    // REMOVED: $payment_method = $_POST['payment_method'];
    $down_payment = (float)$_POST['down_payment'];
    $monthly_payment = (float)$_POST['monthly_payment'];
    $term_months = (int)$_POST['term_months'];

    if ($amount <= 0) {
        $err = "Amount must be greater than 0.";
    } elseif ($down_payment < 0 || $monthly_payment < 0) {
        $err = "Payments cannot be negative.";
    } else {
        // REMOVED payment_method from the query and the bind_param
        $stmt = mysqli_prepare(
            $link,
            "UPDATE orders
             SET amount=?, status=?, down_payment=?, monthly_payment=?, term_months=?
             WHERE id=?"
        );
        // "dsddii" corresponds to: amount(d), status(s), down_payment(d), monthly_payment(d), term_months(i), id(i)
        mysqli_stmt_bind_param(
            $stmt,
            "dsddii",
            $amount, $status, $down_payment, $monthly_payment, $term_months, $id
        );
        if (mysqli_stmt_execute($stmt)) {
            $msg = "Order updated successfully!";
        } else {
            $err = "Database error: " . mysqli_error($link);
        }
        mysqli_stmt_close($stmt);
    }
}

/* ---------- FETCH FOR EDIT ---------- */
$edit_order = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = mysqli_prepare($link, "
        SELECT o.*, u.fullname, u.email, c.title, c.model, c.year, c.price
        FROM orders o
        LEFT JOIN users u ON o.user_id = u.id
        LEFT JOIN cars c ON o.car_id = c.id
        WHERE o.id = ?
    ");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $edit_order = mysqli_fetch_assoc($res);
    mysqli_stmt_close($stmt);
}
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<style>
    .table-responsive { overflow-x:auto; }
    .btn-sm { font-size:.8rem; }
    .badge-pending { background:#ffc107; color:#212529; }
    .badge-completed { background:#28a745; }
    .badge-cancelled { background:#dc3545; }
</style>

<div class="page-content"><div class="container-fluid">
    <?php if ($msg): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?=htmlspecialchars($msg)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if ($err): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?=htmlspecialchars($err)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row"><div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">Car Purchase Orders</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="orderTable" class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>User</th>
                                <th>Car</th>
                                <th>Order Date</th>
                                <th>Amount</th>
                                <th>Down Payment</th>
                                <th>Monthly</th>
                                <th>Term (Months)</th>
                                <th>Payment Method</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
<?php
$result = mysqli_query($link, "
    SELECT 
        o.id, o.order_date, o.amount, o.down_payment, o.monthly_payment, o.term_months,
        o.payment_method, o.status,
        u.fullname, u.email,
        c.title, c.model, c.year
    FROM orders o
    LEFT JOIN users u ON o.user_id = u.id
    LEFT JOIN cars c ON o.car_id = c.id
    ORDER BY o.id DESC
");

while ($row = mysqli_fetch_assoc($result)):
    // User display
    $userDisplay = 'N/A';
    if ($row['fullname'] || $row['email']) {
        $userDisplay = htmlspecialchars($row['fullname'] ?? 'Unknown');
        if ($row['email']) {
            $userDisplay .= '<br><small class="text-muted">' . htmlspecialchars($row['email']) . '</small>';
        }
    }

    // Car display
    $carDisplay = 'N/A';
    if ($row['title']) {
        $carDisplay = '<strong>' . htmlspecialchars($row['title']) . '</strong><br>';
        $carDisplay .= '<small class="text-muted">' . htmlspecialchars($row['model'] . ' ' . $row['year']) . '</small>';
    }

    $statusClass = 'bg-secondary';
    $statusText = ucfirst($row['status'] ?? 'unknown');
    switch (strtolower($row['status'] ?? '')) {
        case 'completed': $statusClass = 'badge-completed'; break;
        case 'pending':   $statusClass = 'badge-pending';   break;
        case 'cancelled': $statusClass = 'badge-cancelled'; break;
    }
?>
                            <tr>
                                <td><?= $userDisplay ?></td>
                                <td><?= $carDisplay ?></td>
                                <td><?= date('M j, Y H:i', strtotime($row['order_date'])) ?></td>
                                <td>$<?= number_format($row['amount'], 2) ?></td>
                                <td>$<?= number_format($row['down_payment'], 2) ?></td>
                                <td>$<?= number_format($row['monthly_payment'], 2) ?></td>
                                <td><?= $row['term_months'] ?></td>
                                <td><span class="badge bg-info"><?= ucfirst($row['payment_method'] ?? 'N/A') ?></span></td>
                                <td><span class="badge <?= $statusClass ?>"><?= ucfirst($row['status'] ?? '') ?></span></td>
                                <td>
                                    <button class="btn btn-sm btn-info text-white"
                                            onclick='editOrder(<?= json_encode($row) ?>)'>Edit</button>
                                </td>
                            </tr>
<?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div></div>
</div></div>

<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Order #<span id="orderIdLabel"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="order_id">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">User</label>
                            <input type="text" id="user_display" class="form-control" disabled>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Car</label>
                            <input type="text" id="car_display" class="form-control" disabled>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Order Date</label>
                            <input type="text" id="order_date_display" class="form-control" disabled>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Total Amount ($)</label>
                            <input type="number" step="0.01" name="amount" id="amount" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Down Payment ($)</label>
                            <input type="number" step="0.01" name="down_payment" id="down_payment" class="form-control" min="0" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Monthly Payment ($)</label>
                            <input type="number" step="0.01" name="monthly_payment" id="monthly_payment" class="form-control" min="0" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Term (Months)</label>
                            <input type="number" name="term_months" id="term_months" class="form-control" min="1" required>
                        </div>
                        
                        <div class="col-md-4">
                            <label class="form-label">Status</label>
                            <select name="status" id="status" class="form-select" required>
                                <option value="pending">Pending</option>
                                <option value="completed">Completed</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="save_order" class="btn btn-success">Save Changes</button>
                </div>
            </div>
        </form>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
$(function(){
    $('#orderTable').DataTable({
        responsive: true,
        columnDefs: [{ targets: 9, orderable: false }] // Action column
    });
});

function editOrder(order){
    $('#orderIdLabel').text(order.id);
    $('#order_id').val(order.id);

    // Display user
    let userText = order.fullname || 'Unknown';
    if (order.email) userText += ' (' + order.email + ')';
    $('#user_display').val(userText);

    // Display car
    let carText = order.title || 'N/A';
    if (order.model && order.year) carText += ' - ' + order.model + ' ' + order.year;
    $('#car_display').val(carText);

    $('#order_date_display').val(order.order_date);

    $('#amount').val(order.amount);
    $('#down_payment').val(order.down_payment);
    $('#monthly_payment').val(order.monthly_payment);
    $('#term_months').val(order.term_months);
    // REMOVED: $('#payment_method').val(order.payment_method);
    $('#status').val(order.status);

    $('#editModal').modal('show');
}
</script>

<?php include 'footer.php'; ?>