<?php
include 'header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Support Tickets</title>
    <style>
        /* Your existing CSS styles */
    </style>
</head>
<body>
    <div class="container">
        <!-- Support Tickets Table -->
        <div class="card">
            <div class="card-header">Support Tickets</div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Department</th>
                                <th>Subject</th>
                                <th>Message</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 0;
                            // Fetch unique tickets (latest ticket per user)
                            $query = "
                                SELECT sc.* 
                                FROM support_chat sc
                                INNER JOIN (
                                    SELECT userid, MAX(created_at) AS latest 
                                    FROM support_chat 
                                    GROUP BY userid
                                ) AS latest_tickets 
                                ON sc.userid = latest_tickets.userid AND sc.created_at = latest_tickets.latest
                            ";
                            $select = mysqli_query($link, $query);

                            if (!$select) {
                                die("Query failed: " . mysqli_error($link));
                            }

                            if (mysqli_num_rows($select) > 0) {
                                while ($row = mysqli_fetch_assoc($select)) {
                                    $id = $row['id'];
                                    $i++;
                            ?>
                                    <tr>
                                        <td><?php echo $i; ?></td>
                                        <td><?php echo htmlspecialchars($row['department']); ?></td>
                                        <td><?php echo htmlspecialchars($row['subject']); ?></td>
                                        <td><?php echo htmlspecialchars($row['message']); ?></td>
                                        <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                                        <td>
                                            <a class="btn btn-primary" href="admin_chat.php?userid=<?php echo $row['userid']; ?>">View Chat</a>
                                        </td>
                                    </tr>
                            <?php
                                }
                            } else {
                                echo "<tr><td colspan='6'>No support tickets found.</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php include 'footer.php'; ?>
</body>
</html>