<?php
include 'header.php';

$err = "";
$msg =  "";
$successCount = 0;
$failureCount = 0;

if (isset($_POST['send'])) {
    // Retrieve form data
    $subject = trim($_POST['subject']);
    $message = trim($_POST['message']);

    // Check if the subject and message are not empty
    if (empty($subject) || empty($message)) {
        $err = "Subject and message are required.";
        echo "<script>alert('$err');</script>";
        exit;
    }

    // Fetch all subscribers' emails from the database using mysqli
    $query = "SELECT email FROM users";
    $result = mysqli_query($link, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        // Loop through all subscribers and send an email to each one
        while ($subscriber = mysqli_fetch_assoc($result)) {
            $email = $subscriber['email'];
            $body = "
                <div style='background: #E4E9F0; padding: 20px; font-family: Arial, sans-serif;'>
                    <div style='max-width: 600px; margin: 0 auto; background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);'>
                        <!-- Header -->
                        <div style='background-color: #1e293b; padding: 16px; display: flex; align-items: center;'>
                            <div style='display: flex; align-items: center;'>
                                <center><img src='$siteurl/app/image/logo.png' width='100px' style='margin-right: 8px;'></center>
                            </div>
                        </div>

                        <!-- Main Content -->
                        <div style='padding: 32px; text-align: center;'>
                            <h1 style='font-size: 28px; color: #1e293b; margin-bottom: 24px; line-height: 1.2;'>$subject</h1>
                            <p style='font-size: 18px; color: #4b5563; margin-bottom: 32px;'></p>
                            <center><h2>Details</h2></center>
                            <p style='font-size: 18px; color: #4b5563; margin-bottom: 24px;'><b>$message</b></p>
                            <div style='margin-top: 32px; border-top: 1px solid #e5e7eb; padding-top: 24px; text-align: left;'>
                                <p style='color: #4b5563; margin-bottom: 8px;'>Thanks,</p>
                                <p style='color: #4b5563; font-weight: bold;'>Support Team, $sitename</p>
                            </div>
                            <div style='margin-top: 32px; font-size: 12px; color: #6b7280; text-align: left;'>
                                <p style='margin-bottom: 4px;'>Please consider all emails from us as confidential.</p>
                            </div>
                        </div>
                    </div>
                </div>";
            
            // Send the email
            $send = sendMail($email, $subject, $body);

        }
  $msg = "Email sent Successfully to all users";
      
    } else {
        echo "No subscribers found.";
    }
}
?>


<div class="page-content">
    <div class="container-fluid">
<?php 
	if ($msg != "") {
		echo customAlert("success", $msg);
	}
	if ($err != "") {
		echo customAlert("error", $err);
	}

 ?>

    	<div class="row">
            <div class="col-lg-12">
                <div class="card">
                	<div class="card-body">
                		<div class="card-header">
			                <h4 class="card-title mb-0">Send Mail to all users</h4>
			            </div>
			            <form method="post" action="sendmail.php">
                        <div class="live-preview">
                            <div class="row gy-4">
                                <div class="col-xxl-6 col-md-12">
                                    <div>
                                        <label for="basiInput" class="form-label">Subject</label>
                                        <input type="text" class="form-control" name="subject" required id="basiInput">
                                    </div>
                                </div>
                       
                                <div class="col-xxl-6 col-md-12">
                                    <div>
                                        <label for="basiInput" class="form-label">Message</label>
                                        <textarea class="form-control" rows="5" name="message" required placeholder="Type Message..."></textarea>
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-md-12">
                                    <div>
                                        <button type="submit" name="send" class="btn btn-primary">Send</button>
                                    </div>
                                </div>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>


	</div>
</div>
<?php include 'footer.php'; ?>