<?php 
include 'header.php'; 
$msg = "";
$err = "";

if (isset($_POST['send'])) {
    $user_id = intval($_POST['user_id']); 
    $title = text_input($_POST['title']);
    $message_content = text_input($_POST['message']);

    if (!empty($title) && !empty($message_content) && $user_id > 0) {
        // Fetch user data
        $query = mysqli_query($link, "SELECT * FROM users WHERE id = $user_id");
        if (mysqli_num_rows($query) > 0) {
            $data = mysqli_fetch_assoc($query);
            $user_email = $data['email'];
            $fullname = $data['fname'];

            // Insert into notifications table
            $date_sent = date("Y-m-d H:i:s");
            $insertNotif = mysqli_query($link, "INSERT INTO notifications (user_id, title, message, date_sent) VALUES ('$user_id', '$title', '$message_content', '$date_sent')");

            if ($insertNotif) {
                // Email content
                $email_message = "<p>Dear $fullname,</p>" .
                                 "<p>$message_content</p>" .
                                 "<p>Best Regards,<br>The Support Team</p>";

                // Send email
                if (sendMail($user_email, $fullname, $title, $email_message)) {
                    $msg = "Notification sent and email delivered to $fullname.";
                } else {
                    $err = "Failed to send the email.";
                }
            } else {
                $err = "Failed to save the notification.";
            }
        } else {
            $err = "User not found.";
        }
    } else {
        $err = "All fields are required.";
    }
}
?>

<style>
select.form-control {
    color: black !important;
}


</style>

<div class="page-content">
    <div class="container-fluid">
        <?php 
        if ($msg != "") {
            echo customAlert("success", $msg);
        }
        if ($err != "") {
            echo customAlert("error", $err);
        }
        ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Send Notification to User</h4>
                        </div>
                        <form method="post" action="">
    <div class="live-preview">
        <div class="row gy-4">
            <!-- Dropdown for Users -->
          <div class="col-xxl-6 col-md-12">
    <label for="userSelect" class="form-label">Select User</label>
            <select class="form-control" name="user_id" id="userSelect" required style="color: black;">
                <option value="">-- Select User --</option>
                <?php
                $users = mysqli_query($link, "SELECT * FROM users");
                while ($user = mysqli_fetch_assoc($users)) {
                ?>
                  <option style="color: black;" value="<?php echo $user['id'] ?>"><?php echo $user['fname'] ?></option>
                  <?php } ?>
            </select>
        </div>


            <div class="col-xxl-6 col-md-12">
                <label for="titleInput" class="form-label">Title of the Message</label>
                <input type="text" class="form-control" name="title" id="titleInput" required>
            </div>

            <!-- Message -->
            <div class="col-xxl-6 col-md-12">
                <label for="messageInput" class="form-label">Message</label>
                <textarea class="form-control" rows="5" name="message" id="messageInput" placeholder="Type Message..." required></textarea>
            </div>

            <!-- Submit Button -->
            <div class="col-xxl-6 col-md-12">
                <button type="submit" name="send" class="btn btn-primary">Send Notification</button>
            </div>
        </div>
    </div>
</form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
