<?php 
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../config/admindb.php';
include '../config/config.php';
include '../config/function.php';

$msg = "";
$email_err = $password_err = ""; 
$email = $password = "";

if (isset($_POST['signin'])) {
    if (empty($_POST["email"])) {
        $email_err = "Email is required";
    } else {
        $email = text_input($_POST["email"]);
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $email_err = "Invalid email format"; 
        }
    }
    
    if (empty($_POST["password"])) {
        $password_err = "Password is required";
    } else {
        $password = text_input($_POST["password"]);
    }

    if($email == "" || $password == ""){
        $msg = "Email or Password fields cannot be empty!";
    } else {
        $sql = mysqli_query($link, "SELECT id, email, password FROM admin WHERE email='$email' AND password= '$password'");
        if(mysqli_num_rows($sql) > 0){
            $data = mysqli_fetch_assoc($sql);
            $_SESSION['adminemail'] = $data['email'];
            $_SESSION['adminid'] = $data['id'];
            echo "<script>window.location.href = 'index.php' </script>";
        } else {
            $msg = "Invalid Email and Password";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Admin Login</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="../logo/logo.png">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: #4361ee;
            --primary-dark: #3a56d4;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --border-color: #dee2e6;
            --shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            width: 100%;
            max-width: 440px;
        }
        
        .login-card {
            background: white;
            border-radius: 16px;
            box-shadow: var(--shadow);
            overflow: hidden;
            transition: var(--transition);
        }
        
        .login-card:hover {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.12);
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 40px 30px 30px;
            text-align: center;
            position: relative;
        }
        
        .login-header::after {
            content: '';
            position: absolute;
            bottom: -20px;
            left: 50%;
            transform: translateX(-50%);
            width: 40px;
            height: 40px;
            background: white;
            border-radius: 50%;
        }
        
        .logo-container {
            margin-bottom: 20px;
        }
        
        .logo {
            max-height: 50px;
            width: auto;
            filter: brightness(0) invert(1);
        }
        
        .login-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .login-subtitle {
            font-size: 0.95rem;
            opacity: 0.9;
            font-weight: 400;
        }
        
        .login-body {
            padding: 50px 40px 40px;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--dark-color);
            font-size: 0.9rem;
        }
        
        .input-group {
            position: relative;
        }
        
        .form-control {
            width: 100%;
            padding: 14px 16px;
            padding-left: 45px;
            border: 2px solid var(--border-color);
            border-radius: 10px;
            font-size: 1rem;
            transition: var(--transition);
            background-color: var(--light-color);
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
            background-color: white;
        }
        
        .input-icon {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--secondary-color);
            font-size: 1.1rem;
            z-index: 2;
        }
        
        .password-toggle {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--secondary-color);
            cursor: pointer;
            font-size: 1.1rem;
            z-index: 2;
        }
        
        .password-toggle:hover {
            color: var(--primary-color);
        }
        
        .error-message {
            color: var(--danger-color);
            font-size: 0.85rem;
            margin-top: 5px;
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .error-message i {
            font-size: 0.9rem;
        }
        
        .alert-message {
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert-danger {
            background-color: rgba(220, 53, 69, 0.1);
            border: 1px solid rgba(220, 53, 69, 0.2);
            color: var(--danger-color);
        }
        
        .btn-login {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }
        
        .btn-login:active {
            transform: translateY(0);
        }
        
        .login-footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--border-color);
            font-size: 0.85rem;
            color: var(--secondary-color);
        }
        
        .copyright {
            opacity: 0.7;
        }
        
        @media (max-width: 576px) {
            .login-container {
                padding: 10px;
            }
            
            .login-body {
                padding: 40px 25px 30px;
            }
            
            .login-header {
                padding: 30px 20px 25px;
            }
        }
        
        @media (max-width: 400px) {
            .login-body {
                padding: 35px 20px 25px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <!--<div class="logo-container">-->
                <!--    <img src="../logo/logo.png" alt="Logo" class="logo">-->
                <!--</div>-->
                <h1 class="login-title">Admin Portal</h1>
                <p class="login-subtitle">Secure access to dashboard</p>
            </div>
            
            <div class="login-body">
                <?php if(!empty($msg)): ?>
                    <div class="alert-message alert-danger">
                        <i class="fas fa-exclamation-circle"></i>
                        <span><?php echo htmlspecialchars($msg); ?></span>
                    </div>
                <?php endif; ?>
                
                <form method="post" action="login.php">
                    <div class="form-group">
                        <label class="form-label">Email Address</label>
                        <div class="input-group">
                            <i class="input-icon fas fa-envelope"></i>
                            <input 
                                type="email" 
                                class="form-control" 
                                name="email" 
                                placeholder="Enter your email"
                                value="<?php echo htmlspecialchars($email); ?>"
                                required
                            >
                        </div>
                        <?php if(!empty($email_err)): ?>
                            <div class="error-message">
                                <i class="fas fa-exclamation-circle"></i>
                                <span><?php echo htmlspecialchars($email_err); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="form-group">
                        <!--<div class="d-flex justify-content-between align-items-center mb-2">-->
                        <!--    <label class="form-label">Password</label>-->
                        <!--    <button type="button" class="btn btn-link btn-sm p-0" style="font-size: 0.85rem; text-decoration: none;" onclick="alert('Please contact system administrator for password reset.')">-->
                        <!--        Forgot Password?-->
                        <!--    </button>-->
                        <!--</div>-->
                        <div class="input-group">
                            <i class="input-icon fas fa-lock"></i>
                            <input 
                                type="password" 
                                class="form-control" 
                                id="password"
                                name="password" 
                                placeholder="Enter your password"
                                required
                            >
                            <button type="button" class="password-toggle" id="togglePassword">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <?php if(!empty($password_err)): ?>
                            <div class="error-message">
                                <i class="fas fa-exclamation-circle"></i>
                                <span><?php echo htmlspecialchars($password_err); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <button type="submit" name="signin" class="btn-login">
                        <i class="fas fa-sign-in-alt"></i>
                        <span>Sign In</span>
                    </button>
                </form>
                
                <div class="login-footer">
                    <p class="copyright">© <?php echo date('Y'); ?> Admin Portal. All rights reserved.</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Password visibility toggle
        const togglePassword = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('password');
        
        togglePassword.addEventListener('click', function() {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            this.innerHTML = type === 'password' ? '<i class="fas fa-eye"></i>' : '<i class="fas fa-eye-slash"></i>';
        });
        
       
    </script>
</body>
</html>