<?php 
include 'header.php';
include "investors_query.php";
?>

<div class="page-content">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Investment Dashboard</h4>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item active">Overview</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <!-- Key Metrics Section -->
        <div class="row">
            <div class="col-12">
                <div class="d-flex align-items-center justify-content-between mb-4">
                    <h5 class="card-title mb-0">Key Metrics</h5>
                    <div class="text-muted">Real-time statistics</div>
                </div>
            </div>
        </div>

        <!-- Stats Cards - First Row -->
        <div class="row g-3 mb-4">
            <!-- Total Users Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card card-animate border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium mb-2">Total Users</p>
                                <h2 class="mb-0 fw-bold"><?php echo number_format($total); ?></h2>
                                <div class="mt-2">
                                    <span class="badge bg-success-subtle text-success fs-12">
                                        <i class="ri-user-line align-middle"></i> Active
                                    </span>
                                </div>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-sm rounded-circle bg-soft-primary p-3">
                                    <i class="ri-user-line text-primary fs-24"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Invested Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card card-animate border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium mb-2">Total Invested</p>
                                <h2 class="mb-0 fw-bold">$<?php echo number_format($invest, 2); ?></h2>
                                <div class="mt-2">
                                    <span class="badge bg-info-subtle text-info fs-12">
                                        <i class="ri-arrow-up-line align-middle"></i> Capital
                                    </span>
                                </div>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-sm rounded-circle bg-soft-info p-3">
                                    <i class="ri-money-dollar-circle-line text-info fs-24"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Staked Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card card-animate border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium mb-2">Total Staked</p>
                                <h2 class="mb-0 fw-bold">$<?php echo number_format($stake, 2); ?></h2>
                                <div class="mt-2">
                                    <span class="badge bg-warning-subtle text-warning fs-12">
                                        <i class="ri-lock-line align-middle"></i> Locked
                                    </span>
                                </div>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-sm rounded-circle bg-soft-warning p-3">
                                    <i class="ri-stack-line text-warning fs-24"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Withdrawn Card -->
            <div class="col-xl-3 col-md-6">
                <div class="card card-animate border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="text-muted fw-medium mb-2">Total Withdrawn</p>
                                <h2 class="mb-0 fw-bold">$<?php echo number_format($withdraw, 2); ?></h2>
                                <div class="mt-2">
                                    <span class="badge bg-danger-subtle text-danger fs-12">
                                        <i class="ri-arrow-down-line align-middle"></i> Outflow
                                    </span>
                                </div>
                            </div>
                            <div class="flex-shrink-0">
                                <div class="avatar-sm rounded-circle bg-soft-danger p-3">
                                    <i class="ri-bank-card-line text-danger fs-24"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Secondary Metrics Section -->
        <div class="row mb-4">
            <div class="col-12">
                <h5 class="card-title mb-4">Transaction Overview</h5>
            </div>
        </div>

        <!-- Stats Cards - Second Row -->
        <div class="row g-3">
            <!-- Total Deposited Card -->
            <div class="col-xl-6 col-md-6">
                <div class="card card-animate border-0 shadow-sm h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center h-100">
                            <div class="flex-grow-1">
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <p class="text-muted fw-medium mb-0">Total Deposited</p>
                                    <div class="avatar-xs flex-shrink-0">
                                        <span class="avatar-title bg-soft-success rounded-circle">
                                            <i class="ri-arrow-up-circle-line text-success"></i>
                                        </span>
                                    </div>
                                </div>
                                <h2 class="mb-1 fw-bold">$<?php echo number_format($deposit, 2); ?></h2>
                                <div class="d-flex align-items-center mt-3">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="progress" style="width: 80px; height: 6px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: 75%" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="text-muted mb-0 fs-13">Incoming transactions</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Summary Card -->
            <div class="col-xl-6 col-md-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body p-4">
                        <h6 class="card-title mb-4">Quick Summary</h6>
                        <div class="row g-3">
                            <div class="col-6">
                                <div class="border rounded p-3">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="ri-user-add-line text-primary fs-18"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <p class="text-muted mb-1 fs-13">Active Users</p>
                                            <h5 class="mb-0"><?php echo number_format($total); ?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="border rounded p-3">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="ri-exchange-dollar-line text-success fs-18"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <p class="text-muted mb-1 fs-13">Net Flow</p>
                                            <h5 class="mb-0">$<?php echo number_format($deposit - $withdraw, 2); ?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 mt-3">
                                <div class="alert alert-info bg-soft-info border-0 mb-0">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="ri-information-line fs-18"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <p class="mb-0 fs-13">Total platform value: $<?php echo number_format($invest + $stake + $deposit, 2); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php 
include 'footer.php';
?>