<?php
include 'header.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$msg = $err = "";
/* ---------- SAVE (UPDATE BUY/SELL ONLY) ---------- */
if (isset($_POST['save_investment'])) {
    $id = (int)$_POST['id'];
    $type = $_POST['type']; // buy or sell
    $amount = (float)$_POST['amount'];
    $fee = (float)$_POST['fee'];
    $status = $_POST['status'];
    // NAV comes from the hidden field (read-only in form)
    $plan_nav = (float)$_POST['plan_nav'];
    // Recalculate
    $units = $plan_nav > 0 ? $amount / $plan_nav : 0;
    $total_cost = $amount + $fee;
    if ($amount <= 0) {
        $err = "Amount must be greater than 0.";
    } elseif ($plan_nav <= 0) {
        $err = "Plan NAV must be greater than 0.";
    } else {
        $stmt = mysqli_prepare(
            $link,
            "UPDATE investments
             SET type=?, amount=?, units=?, fee=?, total_cost=?, status=?
             WHERE id=? AND type IN ('buy','sell')"
        );
        mysqli_stmt_bind_param(
            $stmt,
            "sddddsi",
            $type, $amount, $units, $fee, $total_cost, $status, $id
        );
        if (mysqli_stmt_execute($stmt)) {
            $msg = "Investment transaction updated successfully!";
        } else {
            $err = "Database error: " . mysqli_error($link);
        }
    }
}
/* ---------- FETCH FOR EDIT ---------- */
$edit_tx = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = mysqli_prepare($link, "SELECT * FROM investments WHERE id=? AND type IN ('buy','sell')");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $edit_tx = mysqli_fetch_assoc($res);
}
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<style>
    .table-responsive { overflow-x:auto; }
    .btn-sm { font-size:.8rem; }
    .badge-buy { background:#28a745; }
    .badge-sell { background:#dc3545; }
    .badge-risk-low { background:#198754; }
    .badge-risk-mod { background:#ffc107; color:#212529; }
    .badge-risk-high { background:#dc3545; }
</style>
<div class="page-content"><div class="container-fluid">
    <?php if ($msg): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?=htmlspecialchars($msg)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if ($err): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?=htmlspecialchars($err)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <div class="row"><div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">Edit Investment Transactions (Buy / Sell)</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="invTable" class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>User</th>
                                <th>Plan</th>
                                <th>Category</th>
                                <th>Risk</th>
                                <th>NAV</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Units</th>
                                <th>Fee</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
<?php
// Modified query: join with users table to get fullname and email - NOW FROM investments
$result = mysqli_query($link, "
    SELECT i.*, u.fullname, u.email 
    FROM investments i
    LEFT JOIN users u ON i.user_id = u.id
    WHERE i.type IN ('buy','sell')
    ORDER BY i.id DESC
");
while ($row = mysqli_fetch_assoc($result)):
    $typeClass = $row['type'] == 'buy' ? 'badge-buy' : 'badge-sell';
   
    // Compatible replacement for match expression
    $risk = strtolower($row['plan_risk'] ?? '');
   
    switch ($risk) {
        case 'low':
            $riskClass = 'badge-risk-low';
            break;
        case 'moderate':
            $riskClass = 'badge-risk-mod';
            break;
        case 'high':
        case 'aggressive':
            $riskClass = 'badge-risk-high';
            break;
        default:
            $riskClass = 'bg-secondary';
            break;
    }

    // Prepare user display: fullname (email)
    $userDisplay = 'N/A';
    if ($row['fullname'] || $row['email']) {
        $userDisplay = htmlspecialchars($row['fullname'] ?? 'Unknown');
        if ($row['email']) {
            $userDisplay .= '<br><small class="text-muted">' . htmlspecialchars($row['email']) . '</small>';
        }
    }
?>
                            <tr>
                                <td><?= $userDisplay ?></td>
                                <td><strong><?= htmlspecialchars($row['plan_name'] ?? 'N/A') ?></strong></td>
                                <td><span class="badge bg-info"><?= ucfirst($row['plan_category'] ?? '') ?></span></td>
                                <td><span class="badge <?= $riskClass ?>"><?= ucfirst($row['plan_risk'] ?? '') ?></span></td>
                                <td>$<?= number_format($row['plan_nav'] ?? 0, 4) ?></td>
                                <td><span class="badge <?= $typeClass ?>"><?= strtoupper($row['type']) ?></span></td>
                                <td>$<?= number_format($row['amount'], 2) ?></td>
                                <td><?= number_format($row['units'] ?? 0, 6) ?></td>
                                <td>$<?= number_format($row['fee'] ?? 0, 2) ?></td>
                                <td>$<?= number_format($row['total_cost'] ?? 0, 2) ?></td>
                                <td>
                                    <span class="badge bg-<?= $row['status']=='confirmed'?'success':($row['status']=='pending'?'warning':'secondary') ?>">
                                        <?= ucfirst($row['status'] ?? '') ?>
                                    </span>
                                </td>
                                <td><?= date('M j, Y H:i', strtotime($row['created_at'])) ?></td>
                                <td>
                                    <button class="btn btn-sm btn-info text-white"
                                            onclick='editInvestment(<?= json_encode($row) ?>)'>Edit</button>
                                </td>
                            </tr>
<?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div></div>
</div></div>

<!-- ==================== EDIT MODAL ==================== -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Investment #<span id="txIdLabel"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="tx_id">
                    <input type="hidden" name="plan_nav" id="plan_nav_hidden">
                    <div class="row g-3">
                        <!-- Context (read-only) -->
                        <div class="col-md-6">
                            <label class="form-label">Plan Name</label>
                            <input type="text" id="plan_name_display" class="form-control" disabled>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Category</label>
                            <input type="text" id="plan_category_display" class="form-control" disabled>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Risk</label>
                            <input type="text" id="plan_risk_display" class="form-control" disabled>
                        </div>
                        <!-- Editable -->
                        <div class="col-md-4">
                            <label class="form-label">NAV per Unit ($)</label>
                            <input type="number" step="0.0001" id="plan_nav" class="form-control" disabled>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Type <span class="text-danger">*</span></label>
                            <select name="type" id="type" class="form-select" required>
                                <option value="buy">Buy</option>
                                <option value="sell">Sell</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Investment Amount ($)</label>
                            <input type="number" step="0.01" name="amount" id="amount" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Fee ($)</label>
                            <input type="number" step="0.01" name="fee" id="fee" class="form-control" min="0" value="0" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Units (auto)</label>
                            <input type="text" id="units_display" class="form-control" disabled>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Total Cost (auto)</label>
                            <input type="text" id="total_cost_display" class="form-control" disabled>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Status</label>
                            <select name="status" id="status" class="form-select" required>
                                <option value="pending">Pending</option>
                                <option value="confirmed">Confirmed</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="save_investment" class="btn btn-success">Save Changes</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- ==================== SCRIPTS ==================== -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
$(function(){
    $('#invTable').DataTable({
        responsive: true,
        columnDefs: [{ targets: 12, orderable: false }]
    });
});

function editInvestment(tx){
    $('#txIdLabel').text(tx.id);
    $('#tx_id').val(tx.id);
    $('#plan_name_display').val(tx.plan_name || 'N/A');
    $('#plan_category_display').val(tx.plan_category || '');
    $('#plan_risk_display').val(tx.plan_risk || '');
    $('#plan_nav').val(tx.plan_nav || 0);
    $('#plan_nav_hidden').val(tx.plan_nav || 0);
    $('#type').val(tx.type);
    $('#amount').val(tx.amount);
    $('#fee').val(tx.fee || 0);
    $('#status').val(tx.status);
    calculateInvestment();
    $('#editModal').modal('show');
}

/* Auto-calculate units & total */
$(document).on('input', '#amount, #fee', calculateInvestment);

function calculateInvestment(){
    const nav = parseFloat($('#plan_nav_hidden').val()) || 0;
    const amount = parseFloat($('#amount').val()) || 0;
    const fee = parseFloat($('#fee').val()) || 0;
    const units = nav > 0 ? (amount / nav) : 0;
    const total = amount + fee;
    $('#units_display').val(units.toFixed(6));
    $('#total_cost_display').val('$' + total.toFixed(2));
}
</script>
<?php include 'footer.php'; ?>