<?php
include 'header.php';
$msg = $err = "";
/* ---------- SAVE (UPDATE ONLY) ---------- */
if (isset($_POST['save_tx'])) {
    $id = (int)$_POST['id'];
    $type = $_POST['type']; // buy / sell
    $shares = (float)$_POST['shares'];
    $price_per_share = (float)$_POST['price_per_share'];
    $fee = (float)$_POST['fee'];
    $status = $_POST['status']; // active / cancelled
    // Recalculate total_amount
    $total_amount = ($shares * $price_per_share) + $fee;
    // Basic validation
    if ($shares <= 0 || $price_per_share <= 0) {
        $err = "Shares and Price per share must be greater than 0.";
    } else {
        $stmt = mysqli_prepare(
            $link,
            "UPDATE stock_transactions
             SET type=?, shares=?, price_per_share=?, total_amount=?, fee=?, status=?
             WHERE id=?"
        );
        mysqli_stmt_bind_param(
            $stmt,
            "sddddsi",
            $type, $shares, $price_per_share, $total_amount, $fee, $status, $id
        );
        if (mysqli_stmt_execute($stmt)) {
            $msg = "Transaction updated successfully!";
        } else {
            $err = "Database error: " . mysqli_error($link);
        }
    }
}
/* ---------- FETCH FOR EDIT ---------- */
$edit_tx = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = mysqli_prepare($link, "SELECT * FROM stock_transactions WHERE id=?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $edit_tx = mysqli_fetch_assoc($res);
}
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<style>
    .table-responsive { overflow-x:auto; }
    .btn-sm { font-size:.8rem; }
    .badge-buy { background:#28a745; }
    .badge-sell { background:#dc3545; }
</style>
<div class="page-content"><div class="container-fluid">
    <?php if ($msg): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?=htmlspecialchars($msg)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if ($err): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?=htmlspecialchars($err)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <div class="row"><div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">Edit Stock Transactions</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="txTable" class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th> <!-- Sequential number -->
                                <th>User</th> <!-- Now shows name + email -->
                                <th>Symbol</th>
                                <th>Company</th>
                                <th>Type</th>
                                <th>Shares</th>
                                <th>Price/Share</th>
                                <th>Total</th>
                                <th>Fee</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
<?php
// Join with users table to get fullname and email
$result = mysqli_query($link, "
    SELECT st.*, u.fullname, u.email 
    FROM stock_transactions st
    LEFT JOIN users u ON st.user_id = u.id
    ORDER BY st.id DESC
");

$row_number = 1; // For sequential numbering
while ($row = mysqli_fetch_assoc($result)):
    $typeClass = $row['type']=='buy' ? 'badge-buy' : 'badge-sell';

    // Prepare user display: fullname + email
    $userDisplay = 'N/A';
    if ($row['fullname'] || $row['email']) {
        $userDisplay = htmlspecialchars($row['fullname'] ?? 'Unknown');
        if ($row['email']) {
            $userDisplay .= '<br><small class="text-muted">' . htmlspecialchars($row['email']) . '</small>';
        }
    }
?>
                            <tr>
                                <td><?= $row_number ?></td>
                                <td><?= $userDisplay ?></td> <!-- Name + Email -->
                                <td><strong><?= htmlspecialchars($row['symbol']) ?></strong></td>
                                <td><?= htmlspecialchars($row['company_name']) ?></td>
                                <td><span class="badge <?= $typeClass ?>"><?= ucfirst($row['type']) ?></span></td>
                                <td><?= number_format($row['shares'], 6) ?></td>
                                <td>$<?= number_format($row['price_per_share'], 4) ?></td>
                                <td>$<?= number_format($row['total_amount'], 2) ?></td>
                                <td>$<?= number_format($row['fee'], 2) ?></td>
                                <td><span class="badge bg-<?= $row['status']=='active'?'success':'secondary' ?>">
                                    <?= ucfirst($row['status']) ?>
                                    </span></td>
                                <td><?= date('M j, Y H:i', strtotime($row['created_at'])) ?></td>
                                <td>
                                    <button class="btn btn-sm btn-info text-white"
                                            onclick='editTx(<?= json_encode($row) ?>)'>Edit</button>
                                </td>
                            </tr>
<?php
    $row_number++;
endwhile; 
?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div></div>
</div></div>
<!-- ==================== EDIT MODAL ==================== -->
<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Transaction #<span id="txIdLabel"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="tx_id">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Transaction Type</label>
                            <select name="type" id="type" class="form-select" required>
                                <option value="buy">Buy</option>
                                <option value="sell">Sell</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Status</label>
                            <select name="status" id="status" class="form-select" required>
                                <option value="active">Active</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Shares</label>
                            <input type="number" step="0.000001" name="shares" id="shares"
                                   class="form-control" min="0.000001" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Price per Share ($)</label>
                            <input type="number" step="0.0001" name="price_per_share" id="price_per_share"
                                   class="form-control" min="0.0001" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Fee ($)</label>
                            <input type="number" step="0.01" name="fee" id="fee"
                                   class="form-control" min="0" value="0" required>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Total Amount (auto-calculated)</label>
                            <input type="text" id="total_amount_display" class="form-control" disabled>
                        </div>
                        <!-- Read-only fields for context -->
                        <div class="col-md-4">
                            <label class="form-label">Symbol</label>
                            <input type="text" id="symbol_display" class="form-control" disabled>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label">Company</label>
                            <input type="text" id="company_display" class="form-control" disabled>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="save_tx" class="btn btn-success">Save Changes</button>
                </div>
            </div>
        </form>
    </div>
</div>
<!-- ==================== SCRIPTS ==================== -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
$(function(){
    $('#txTable').DataTable({
        responsive: true,
        columnDefs: [{ targets: 11, orderable: false }] // Action column
    });
});
function editTx(tx){
    $('#txIdLabel').text(tx.id);
    $('#tx_id').val(tx.id);
    $('#type').val(tx.type);
    $('#status').val(tx.status);
    $('#shares').val(tx.shares);
    $('#price_per_share').val(tx.price_per_share);
    $('#fee').val(tx.fee);
    $('#symbol_display').val(tx.symbol);
    $('#company_display').val(tx.company_name);
    calculateTotal();
    $('#editModal').modal('show');
}
/* Auto-calculate total amount */
$('#shares, #price_per_share, #fee').on('input', calculateTotal);
function calculateTotal(){
    const shares = parseFloat($('#shares').val()) || 0;
    const price = parseFloat($('#price_per_share').val()) || 0;
    const fee = parseFloat($('#fee').val()) || 0;
    const total = (shares * price) + fee;
    $('#total_amount_display').val('$' + total.toFixed(2));
}
</script>
<?php include 'footer.php'; ?>