<?php
include 'header.php';
$msg = $err = "";
/* ---------- SAVE (ADD / UPDATE) ---------- */
if (isset($_POST['save_stock'])) {
    $id = !empty($_POST['id']) ? (int)$_POST['id'] : 0;
    $symbol = trim($_POST['symbol']);
    $name = trim($_POST['name']);
    $sector = trim($_POST['sector']);
    $industry = trim($_POST['industry']);
    $logo_url = trim($_POST['logo_url']);
    $price = (float)$_POST['price'];
    $previous_close = (float)$_POST['previous_close'];
    $volume = (int)$_POST['volume'];
    $market_cap = (int)$_POST['market_cap'];
    
    // Basic validation
    if (empty($symbol) || empty($name) || empty($logo_url)) {
        $err = "Symbol, Name and Logo URL are required.";
    } elseif (!filter_var($logo_url, FILTER_VALIDATE_URL)) {
        $err = "Please enter a valid logo URL.";
    } else {
        if ($id > 0) {
            // UPDATE
            $stmt = mysqli_prepare(
                $link,
                "UPDATE stocks SET symbol=?, name=?, sector=?, industry=?, logo_url=?, price=?, previous_close=?, volume=?, market_cap=? WHERE id=?"
            );
            mysqli_stmt_bind_param(
                $stmt,
                "sssssddidi",
                $symbol, $name, $sector, $industry, $logo_url, $price, $previous_close, $volume, $market_cap, $id
            );
            $msg = "Stock updated successfully!";
        } else {
            // INSERT
            $stmt = mysqli_prepare(
                $link,
                "INSERT INTO stocks (symbol, name, sector, industry, logo_url, price, previous_close, volume, market_cap, updated_at)
                VALUES (?,?,?,?,?,?,?,?,?,NOW())"
            );
            mysqli_stmt_bind_param(
                $stmt,
                "sssssddid",
                $symbol, $name, $sector, $industry, $logo_url, $price, $previous_close, $volume, $market_cap
            );
            $msg = "Stock added successfully!";
        }
        mysqli_stmt_execute($stmt);
    }
}
/* ---------- DELETE ---------- */
if (isset($_POST['delete_stock'])) {
    $id = (int)$_POST['stock_id'];
    $stmt = mysqli_prepare($link, "DELETE FROM stocks WHERE id=?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $msg = "Stock deleted successfully!";
}
/* ---------- FETCH FOR EDIT ---------- */
$edit_stock = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = mysqli_prepare($link, "SELECT * FROM stocks WHERE id=?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $edit_stock = mysqli_fetch_assoc($res);
}
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<style>
    .table-responsive { overflow-x:auto; }
    .modal-img { max-width:100%; height:auto; }
    .btn-sm { font-size:.8rem; }
    .price-change { font-weight: bold; }
    .positive { color: #28a745; }
    .negative { color: #dc3545; }
</style>
<div class="page-content"><div class="container-fluid">
    <?php if ($msg): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?=htmlspecialchars($msg)?>
 <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if ($err): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?=htmlspecialchars($err)?> <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <div class="row"><div class="col-lg-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title mb-0">Manage Stocks</h4>
                <!--<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addEditModal" onclick="clearForm()">-->
                <!--    Add New Stock-->
                <!--</button>-->
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="stocksTable" class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>ID</th><th>Symbol</th><th>Name</th><th>Sector</th><th>Industry</th>
                                <th>Price</th><th>Change</th><th>Volume</th><th>Market Cap</th><th>Logo</th><th>Updated</th><th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
<?php
$result = mysqli_query($link, "SELECT * FROM stocks ORDER BY id DESC");
while ($row = mysqli_fetch_assoc($result)):
    $price_change = $row['price'] - $row['previous_close'];
    $change_percent = ($price_change / $row['previous_close']) * 100;
    $change_class = $price_change >= 0 ? 'positive' : 'negative';
?>
                            <tr>
                                <td><?= $row['id'] ?></td>
                                <td><strong><?= htmlspecialchars($row['symbol']) ?></strong></td>
                                <td><?= htmlspecialchars($row['name']) ?></td>
                                <td><span class="badge bg-info"><?= htmlspecialchars($row['sector']) ?></span></td>
                                <td><?= htmlspecialchars($row['industry']) ?></td>
                                <td>$<?= number_format($row['price'], 2) ?></td>
                                <td>
                                    <span class="price-change <?= $change_class ?>">
                                        <?= $price_change >= 0 ? '+' : '' ?><?= number_format($price_change, 2) ?>
                                        (<?= number_format($change_percent, 2) ?>%)
                                    </span>
                                </td>
                                <td><?= number_format($row['volume']) ?></td>
                                <td>$<?= number_format($row['market_cap']/1000000000, 1) ?>B</td>
                                <td>
                                    <img src="<?= htmlspecialchars($row['logo_url']) ?>" width="40" height="40" class="rounded"
                                         data-bs-toggle="modal" data-bs-target="#imageModal"
                                         onclick="showImage('<?= htmlspecialchars($row['logo_url']) ?>')"
                                         onerror="this.src='https://via.placeholder.com/40x40?text=No+Logo';">
                                </td>
                                <td><?= date('M j, Y H:i', strtotime($row['updated_at'])) ?></td>
                                <td>
                                    <button class="btn btn-sm btn-info text-white"
                                            onclick='editStock(<?= json_encode($row) ?>)'>Edit</button>
                                    <form method="post" class="d-inline">
                                        <input type="hidden" name="stock_id" value="<?=$row['id']?>">
                                        <button type="submit" name="delete_stock"
                                                class="btn btn-sm btn-danger"
                                                onclick="return confirm('Delete this stock?')">
                                            Delete
                                        </button>
                                    </form>
                                </td>
                            </tr>
<?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div></div>
</div></div>
<!-- ==================== ADD / EDIT MODAL ==================== -->
<div class="modal fade" id="addEditModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">Add New Stock</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="stock_id">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Symbol <span class="text-danger">*</span></label>
                            <input type="text" name="symbol" id="symbol" class="form-control" maxlength="10" required>
                            <div class="form-text">e.g., AAPL, MSFT, TSLA</div>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Sector</label>
                            <input type="text" name="sector" id="sector" class="form-control" placeholder="e.g., Technology">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Industry</label>
                            <input type="text" name="industry" id="industry" class="form-control" placeholder="e.g., Semiconductors">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Current Price ($)</label>
                            <input type="number" step="0.01" name="price" id="price" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Previous Close ($)</label>
                            <input type="number" step="0.01" name="previous_close" id="previous_close" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Volume</label>
                            <input type="number" name="volume" id="volume" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Market Cap</label>
                            <div class="input-group">
                                <input type="number" name="market_cap" id="market_cap" class="form-control" required>
                                <span class="input-group-text">$</span>
                            </div>
                            <div class="form-text">Enter in dollars (e.g., 3100000000000 for $3.1T)</div>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Logo URL <span class="text-danger">*</span></label>
                            <input type="url" name="logo_url" id="logo_url" class="form-control"
                                   placeholder="https://example.com/logo.png" required>
                            <div id="currentLogo" class="mt-2"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="save_stock" class="btn btn-success">Save Stock</button>
                </div>
            </div>
        </form>
    </div>
</div>
<!-- ==================== IMAGE PREVIEW MODAL ==================== -->
<div class="modal fade" id="imageModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <img id="previewImage" src="" class="modal-img">
            </div>
        </div>
    </div>
</div>
<!-- ==================== SCRIPTS ==================== -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script>
$(function(){
    $('#stocksTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy','csv','excel','pdf','print'],
        responsive: true,
        columnDefs: [
            { targets: [9], orderable: false }, // Logo column not sortable
            { targets: [11], orderable: false } // Actions column not sortable
        ]
    });
});

function editStock(stock){
    $('#modalTitle').text('Edit Stock');
    $('#stock_id').val(stock.id);
    $('#symbol').val(stock.symbol);
    $('#name').val(stock.name);
    $('#sector').val(stock.sector);
    $('#industry').val(stock.industry);
    $('#price').val(stock.price);
    $('#previous_close').val(stock.previous_close);
    $('#volume').val(stock.volume);
    $('#market_cap').val(stock.market_cap);
    $('#logo_url').val(stock.logo_url);
    
    // Show current logo
    if (stock.logo_url) {
        $('#currentLogo').html(
            '<img src="' + stock.logo_url + '" width="80" class="rounded mt-2" ' +
            'onerror="this.src=\'https://via.placeholder.com/80x80?text=No+Logo\';">'
        );
    } else {
        $('#currentLogo').html('');
    }
    
    $('#addEditModal').modal('show');
}

function clearForm(){
    $('#modalTitle').text('Add New Stock');
    $('#addEditModal form')[0].reset();
    $('#stock_id').val('');
    $('#currentLogo').html('');
}

function showImage(src){
    $('#previewImage').attr('src', src);
}

// Format market cap input helper
$('#market_cap').on('input', function() {
    let value = $(this).val().replace(/[^\d]/g, '');
    if (value) {
        // Add commas for readability (optional)
        value = value.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
    }
    $(this).val(value);
});
</script>
<?php include 'footer.php'; ?>