<?php
include 'header.php';

$msg = $err = "";

/* ---------- ADD / UPDATE PLAN ---------- */
if (isset($_POST['save_plan'])) {
    $id             = !empty($_POST['id']) ? (int)$_POST['id'] : 0;
    $name           = trim($_POST['name']);
    $category       = trim($_POST['category']);
    $risk_level     = $_POST['risk_level'];
    $nav            = (float)$_POST['nav'];
    $return_1y      = (float)$_POST['return_1y'];
    $min_investment = (float)$_POST['min_investment'];
    $is_featured    = isset($_POST['is_featured']) ? 1 : 0;

    if (empty($name) || empty($category)) {
        $err = "Name and Category are required.";
    } else {
        if ($id > 0) {
            // UPDATE
            $stmt = mysqli_prepare($link, 
                "UPDATE plans SET name=?, category=?, risk_level=?, nav=?, return_1y=?, min_investment=?,  is_featured=? WHERE id=?"
            );
            mysqli_stmt_bind_param($stmt, "sssdddii", $name, $category, $risk_level, $nav, $return_1y, $min_investment, $is_featured, $id);
            $msg = "Plan updated successfully!";
        } else {
            // INSERT
            $date = new DateTime();
          $formattedDate = $date->format('Y-m-d H:i:s');

            $stmt = mysqli_prepare($link,
                "INSERT INTO plans (name, category, risk_level, nav, return_1y, min_investment, is_featured, created_at) 
                 VALUES (?, ?, ?, ?, ?,  ?, ?, ?)"
            );
            mysqli_stmt_bind_param($stmt, "ssdddsii", $name, $category, $risk_level, $nav, $return_1y, $min_investment, $is_featured, $formattedDate);
            $msg = "Plan added successfully!";
        }
        mysqli_stmt_execute($stmt);
    }
}

/* ---------- DELETE PLAN ---------- */
if (isset($_POST['delete_plan'])) {
    $id = (int)$_POST['plan_id'];
    $stmt = mysqli_prepare($link, "DELETE FROM plans WHERE id=?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $msg = "Plan deleted successfully!";
}

/* ---------- TOGGLE FEATURED ---------- */
if (isset($_GET['toggle_featured'])) {
    $id = (int)$_GET['toggle_featured'];
    $stmt = mysqli_prepare($link, "UPDATE plans SET is_featured = NOT is_featured WHERE id=?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    header("Location: all_plans.php");
    exit;
}

/* ---------- FETCH FOR EDIT ---------- */
$edit_plan = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = mysqli_prepare($link, "SELECT * FROM plans WHERE id=?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $edit_plan = mysqli_fetch_assoc($res);
}
?>

<!-- Styles -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">

<style>
    .table-responsive { overflow-x: auto; }
    .badge-risk { font-size: 0.7rem; }
    .btn-sm { font-size: 0.8rem; }
</style>

<div class="page-content">
    <div class="container-fluid">

        <!-- Alerts -->
        <?php if ($msg): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?= htmlspecialchars($msg) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        <?php if ($err): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <?= htmlspecialchars($err) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Manage Investment Plans</h4>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addEditModal" onclick="clearForm()">
                            Add New Plan
                        </button>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="plansTable" class="table table-striped table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Category</th>
                                        <th>Risk</th>
                                        <th>NAV</th>
                                        <th>1Y Return</th>
                                        <th>Min Invest</th>
                                        <!--<th>Description</th>-->
                                        <th>Featured</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $result = mysqli_query($link, "SELECT * FROM plans ORDER BY id DESC");
                                    while ($row = mysqli_fetch_assoc($result)):
                                    ?>
                                    <tr>
                                        <td><?= $row['id'] ?></td>
                                        <td><?= htmlspecialchars($row['name']) ?></td>
                                        <td><?= htmlspecialchars($row['category']) ?></td>
                                        <td>
                                            <span class="badge badge-risk bg-<?= 
                                                $row['risk_level']=='conservative' ? 'success' : 
                                                ($row['risk_level']=='moderate' ? 'warning' : 'danger')
                                            ?>">
                                                <?= ucfirst($row['risk_level']) ?>
                                            </span>
                                        </td>
                                        <td>$<?= number_format($row['nav'], 4) ?></td>
                                        <td><?= $row['return_1y'] ?>%</td>
                                        <td>$<?= number_format($row['min_investment'], 2) ?></td>
                                        <!--<td>-->
                                        <!--    <?= $row['description'] ? htmlspecialchars(substr($row['description'], 0, 50)) . '...' : '<em class="text-muted">No description</em>' ?>-->
                                        <!--</td>-->
                                        <td>
                                            <a href="?toggle_featured=<?= $row['id'] ?>" class="btn btn-sm btn-warning">
                                                <?= $row['is_featured'] ? 'Yes' : 'No' ?>
                                            </a>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-info text-white" onclick='editPlan(<?= json_encode($row) ?>)'>
                                                Edit
                                            </button>
                                            <form method="post" class="d-inline">
                                                <input type="hidden" name="plan_id" value="<?= $row['id'] ?>">
                                                <button type="submit" name="delete_plan" class="btn btn-sm btn-danger"
                                                        onclick="return confirm('Delete this plan?')">
                                                    Delete
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ==================== ADD / EDIT MODAL ==================== -->
<div class="modal fade" id="addEditModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">Add New Plan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="plan_id">

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Plan Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Category <span class="text-danger">*</span></label>
                            <input type="text" name="category" id="category" class="form-control" required>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Risk Level</label>
                            <select name="risk_level" id="risk_level" class="form-select">
                                <option value="conservative">Conservative</option>
                                <option value="moderate">Moderate</option>
                                <option value="aggressive">Aggressive</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">NAV ($)</label>
                            <input type="number" step="0.0001" name="nav" id="nav" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">1Y Return (%)</label>
                            <input type="number" step="0.01" name="return_1y" id="return_1y" class="form-control" required>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Min Investment ($)</label>
                            <input type="number" step="0.01" name="min_investment" id="min_investment" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Featured?</label><br>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="checkbox" name="is_featured" id="is_featured" value="1">
                                <label class="form-check-label">Yes</label>
                            </div>
                        </div>

                        <!--<div class="col-12">-->
                        <!--    <label class="form-label">Description</label>-->
                        <!--    <textarea name="description" id="description" class="form-control" rows="3"></textarea>-->
                        <!--</div>-->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="save_plan" class="btn btn-success">Save Plan</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- ==================== SCRIPTS ==================== -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<script>
$(function(){
    $('#plansTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy','csv','excel','pdf','print'],
        responsive: true,
        columnDefs: [
            { targets: [7], orderable: false } // Disable sort on Description
        ]
    });
});

function editPlan(plan){
    $('#modalTitle').text('Edit Plan');
    $('#plan_id').val(plan.id);
    $('#name').val(plan.name);
    $('#category').val(plan.category);
    $('#risk_level').val(plan.risk_level);
    $('#nav').val(plan.nav);
    $('#return_1y').val(plan.return_1y);
    $('#min_investment').val(plan.min_investment);
    // $('#description').val(plan.description);
    $('#is_featured').prop('checked', plan.is_featured == 1);
    $('#addEditModal').modal('show');
}

function clearForm(){
    $('#modalTitle').text('Add New Plan');
    $('#addEditModal form')[0].reset();
    $('#plan_id').val('');
}
</script>

<?php include 'footer.php'; ?>