<?php
include 'header.php';
$msg = $err = "";

/* ---------- SAVE (ADD / UPDATE) ---------- */
if (isset($_POST['save_car'])) {
    $id = !empty($_POST['id']) ? (int)$_POST['id'] : 0;
    $title = trim($_POST['title'] ?? '');
    $model = trim($_POST['model'] ?? '');
    $year = (int)($_POST['year'] ?? 0);
    $price = (float)($_POST['price'] ?? 0);
    $range_miles = (int)($_POST['range_miles'] ?? 0);
    $accel = (float)($_POST['accel_0_60'] ?? 0);
    $top_speed = (int)($_POST['top_speed'] ?? 0);
    $image_url = trim($_POST['image_url'] ?? '');
    // FORCE status to be valid
    $status = in_array($_POST['status'] ?? '', ['available', 'sold_out']) ? $_POST['status'] : 'available';
    $featured = isset($_POST['featured']) ? 1 : 0;

    // Validation
    if (empty($title) || empty($model) || empty($image_url)) {
        $err = "Title, Model and Image URL are required.";
    } elseif (!filter_var($image_url, FILTER_VALIDATE_URL)) {
        $err = "Please enter a valid image URL.";
    } else {
        if ($id > 0) {
            // UPDATE
            // FIXED: Changed type string "ssidisssdii" to "ssidissssii" (status is 's', not 'd')
            $stmt = mysqli_prepare($link, "UPDATE cars SET title=?, model=?, year=?, price=?, range_miles=?, accel_0_60=?, top_speed=?, image_url=?, status=?, featured=? WHERE id=?");
            mysqli_stmt_bind_param($stmt, "ssidissssii", $title, $model, $year, $price, $range_miles, $accel, $top_speed, $image_url, $status, $featured, $id);
            $msg = "Car updated successfully!";
        } else {
            // INSERT
            // FIXED: Changed type string "ssidisssdi" to "ssidissssi" (status is 's', not 'd')
            $stmt = mysqli_prepare($link, "INSERT INTO cars (title, model, year, price, range_miles, accel_0_60, top_speed, image_url, status, featured, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,NOW())");
            mysqli_stmt_bind_param($stmt, "ssidissssi", $title, $model, $year, $price, $range_miles, $accel, $top_speed, $image_url, $status, $featured);
            $msg = "Car added successfully!";
        }

        if (mysqli_stmt_execute($stmt)) {
            // Success
        } else {
            $err = "Database error: " . mysqli_error($link);
        }
        mysqli_stmt_close($stmt);
    }
}

/* ---------- DELETE ---------- */
if (isset($_POST['delete_car'])) {
    $id = (int)$_POST['car_id'];
    $stmt = mysqli_prepare($link, "DELETE FROM cars WHERE id=?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $msg = "Car deleted successfully!";
}

/* ---------- TOGGLE FEATURED ---------- */
if (isset($_GET['toggle_featured'])) {
    $id = (int)$_GET['toggle_featured'];
    $stmt = mysqli_prepare($link, "UPDATE cars SET featured = NOT featured WHERE id=?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    header("Location: all_cars.php");
    exit;
}
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<style>
    .table-responsive { overflow-x:auto; }
    .modal-img { max-width:100%; height:auto; }
    .btn-sm { font-size:.8rem; }
</style>

<div class="page-content"><div class="container-fluid">
    <?php if ($msg): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?=htmlspecialchars($msg)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if ($err): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?=htmlspecialchars($err)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row"><div class="col-lg-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title mb-0">Manage Cars</h4>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">
                    Add New Car
                </button>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="carsTable" class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>ID</th><th>Title</th><th>Model</th><th>Year</th><th>Price</th>
                                <th>Range</th><th>0-60</th><th>Top Speed</th><th>Image</th>
                                <th>Status</th><th>Featured</th><th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
<?php
$result = mysqli_query($link, "SELECT * FROM cars ORDER BY id DESC");
while ($row = mysqli_fetch_assoc($result)):
?>
                            <tr>
                                <td><?= $row['id'] ?></td>
                                <td><?= htmlspecialchars($row['title']) ?></td>
                                <td><?= htmlspecialchars($row['model']) ?></td>
                                <td><?= $row['year'] ?></td>
                                <td>$<?= number_format($row['price'],2) ?></td>
                                <td><?= $row['range_miles'] ?> mi</td>
                                <td><?= $row['accel_0_60'] ?> s</td>
                                <td><?= $row['top_speed'] ?> mph</td>
                                <td>
                                    <img src="<?= htmlspecialchars($row['image_url']) ?>" width="60" class="rounded cursor-pointer"
                                         onclick="showImage('<?= htmlspecialchars($row['image_url'], ENT_QUOTES) ?>')">
                                </td>
                                <td>
                                    <span class="badge bg-<?= $row['status']=='available'?'success':'secondary' ?>">
                                        <?= ucfirst($row['status'] ?? 'available') ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="?toggle_featured=<?= $row['id'] ?>" class="btn btn-sm btn-warning">
                                        <?= $row['featured'] ? '★ Featured' : '☆ Feature' ?>
                                    </a>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-info text-white"
                                            onclick='editCar(<?= json_encode($row) ?>)'>Edit</button>
                                    <form method="post" class="d-inline">
                                        <input type="hidden" name="car_id" value="<?= $row['id'] ?>">
                                        <button type="submit" name="delete_car"
                                                class="btn btn-sm btn-danger"
                                                onclick="return confirm('Delete this car permanently?')">
                                            Delete
                                        </button>
                                    </form>
                                </td>
                            </tr>
<?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div></div>
</div></div>

<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Car</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Title <span class="text-danger">*</span></label>
                            <input type="text" name="title" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Model <span class="text-danger">*</span></label>
                            <input type="text" name="model" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Year</label>
                            <input type="number" name="year" class="form-control" min="1900" max="2100" value="<?= date('Y') ?>" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Price ($)</label>
                            <input type="number" step="0.01" name="price" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Range (mi)</label>
                            <input type="number" name="range_miles" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">0-60 mph (s)</label>
                            <input type="number" step="0.1" name="accel_0_60" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Top Speed (mph)</label>
                            <input type="number" name="top_speed" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select" required>
                                <option value="available" selected>Available</option>
                                <option value="sold_out">Sold Out</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Featured</label><br>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="checkbox" name="featured" value="1">
                                <label class="form-check-label">Yes</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Image URL <span class="text-danger">*</span></label>
                            <input type="url" name="image_url" class="form-control" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="save_car" class="btn btn-success">Add Car</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" id="editModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Car</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Title <span class="text-danger">*</span></label>
                            <input type="text" name="title" id="edit_title" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Model <span class="text-danger">*</span></label>
                            <input type="text" name="model" id="edit_model" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Year</label>
                            <input type="number" name="year" id="edit_year" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Price ($)</label>
                            <input type="number" step="0.01" name="price" id="edit_price" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Range (mi)</label>
                            <input type="number" name="range_miles" id="edit_range_miles" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">0-60 mph (s)</label>
                            <input type="number" step="0.1" name="accel_0_60" id="edit_accel_0_60" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Top Speed (mph)</label>
                            <input type="number" name="top_speed" id="edit_top_speed" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Status</label>
                            <select name="status" id="edit_status" class="form-select" required>
                                <option value="available">Available</option>
                                <option value="sold_out">Sold Out</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Featured</label><br>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="checkbox" name="featured" id="edit_featured" value="1">
                                <label class="form-check-label">Yes</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Image URL <span class="text-danger">*</span></label>
                            <input type="url" name="image_url" id="edit_image_url" class="form-control" required>
                            <div id="edit_currentImage" class="mt-2"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="save_car" class="btn btn-success">Update Car</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" id="imageModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content">
            <div class="modal-body text-center">
                <img id="previewImage" src="" class="img-fluid rounded">
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<script>
$(function(){
    $('#carsTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy','csv','excel'],
        responsive: true
    });
});

function editCar(car){
    $('#edit_id').val(car.id);
    $('#edit_title').val(car.title);
    $('#edit_model').val(car.model);
    $('#edit_year').val(car.year);
    $('#edit_price').val(car.price);
    $('#edit_range_miles').val(car.range_miles);
    $('#edit_accel_0_60').val(car.accel_0_60);
    $('#edit_top_speed').val(car.top_speed);
    $('#edit_status').val(car.status);
    $('#edit_featured').prop('checked', car.featured == 1);
    $('#edit_image_url').val(car.image_url);
    $('#edit_currentImage').html('<img src="'+car.image_url+'" width="200" class="rounded mt-2 shadow">');
    $('#editModal').modal('show');
}

function showImage(src){
    $('#previewImage').attr('src', src);
    $('#imageModal').modal('show');
}
</script>

<?php include 'footer.php'; ?>